/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutablePortBinding;

@JsonDeserialize(builder=ImmutablePortBinding.Builder.class)
@Value.Immutable
public interface PortBinding {
    @JsonProperty(value="HostIp")
    @Nullable
    public String hostIp();

    @JsonProperty(value="HostPort")
    public String hostPort();

    public static PortBinding of(String ip, String port) {
        return ImmutablePortBinding.builder().hostIp(ip).hostPort(port).build();
    }

    public static PortBinding of(String ip, int port) {
        return ImmutablePortBinding.builder().hostIp(ip).hostPort(String.valueOf(port)).build();
    }

    public static PortBinding randomPort(String ip) {
        return ImmutablePortBinding.builder().hostIp(ip).hostPort("").build();
    }
}

