/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterSetSpaceBeforeEmptyCloseTagTest {
    @Test
    public void testSelfCloseTagSpaceSingleElement() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(true);
        String content = "<a/>";
        String expected = "<a />";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 2, " "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSelfCloseTagSpaceSingleElementMultipleSpaces() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(true);
        String content = "<a         />";
        String expected = "<a />";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 11, " "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSelfCloseTagSpaceSingleElementNewLine() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(true);
        String content = "<a\r\n  />";
        String expected = "<a />";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 1, 2, " "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSelfCloseTagSpace() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(true);
        String content = "<a>\r\n <b/>\r\n</a>";
        String expected = "<a>\r\n  <b />\r\n</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r\n  "), XMLAssert.te(1, 3, 1, 3, " "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSelfCloseTagAlreadyHasSpace() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(true);
        String content = "<a>\r\n <b />\r\n</a>";
        String expected = "<a>\r\n  <b />\r\n</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r\n  "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSelfCloseTagSpaceFalse() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<a>\r\n <b/>\r\n</a>";
        String expected = "<a>\r\n  <b/>\r\n</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r\n  "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSelfCloseTagSpaceFalseAlreadyHasSpace() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<a>\r\n <b />\r\n</a>";
        String expected = "<a>\r\n  <b/>\r\n</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r\n  "), XMLAssert.te(1, 3, 1, 4, ""));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontAddClosingBracket() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<a>\r\n <b\r\n</a>";
        String expected = "<a>\r\n  <b\r\n</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r\n  "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testEndTagMissingCloseBracket() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<a>\r\n <b> Value </b\r\n</a>";
        String expected = "<a>\r\n  <b> Value </b\r\n</a>";
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, "\r\n  "));
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterSetSpaceBeforeEmptyCloseTagTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

