/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import java.util.Arrays;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterPreserveSpacesTest {
    @Test
    public void noPreserveSpaces() throws BadLocationException {
        String content = "<a>b  c</a>";
        String expected = "<a>b c</a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, XMLAssert.te(0, 4, 0, 6, " "));
        XMLFormatterPreserveSpacesTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void preserveSpacesWithXmlSpace() throws BadLocationException {
        String content;
        String expected = content = "<a xml:space=\"preserve\">b  c</a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void preserveSpacesWithXmlSpace2() throws BadLocationException {
        String content = "<a>\r\n  <b>\r\n    c  <d></d>  e\r\n  </b>\r\n  <b xml:space=\"preserve\">\r\n    c  <d></d>  e\r\n  </b>\r\n</a>";
        String expected = "<a>\r\n  <b> c <d></d> e </b>\r\n  <b xml:space=\"preserve\">\r\n    c  <d></d>  e\r\n  </b>\r\n</a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, XMLAssert.te(1, 5, 2, 4, " "), XMLAssert.te(2, 5, 2, 7, " "), XMLAssert.te(2, 14, 2, 16, " "), XMLAssert.te(2, 17, 3, 2, " "));
        XMLFormatterPreserveSpacesTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void preserveSpacesWithSettings() throws BadLocationException {
        String content;
        String expected = content = "<a>b  c</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("a"));
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveSpacesWithDefaultSettings() throws BadLocationException {
        String content;
        String expected = content = "<xsl:text>b \r\n c</xsl:text>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void preserveSpacesWithXsdString() throws Exception {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 src/test/resources/xsd/maven-4.0.0.xsd\">\r\n  <description>a    b     c</description>\r\n  <description2>a    b     c</description2>\r\n</project>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 src/test/resources/xsd/maven-4.0.0.xsd\">\r\n  <description>a    b     c</description>\r\n  <description2>a b c</description2>\r\n</project>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setGrammarAwareFormatting(true);
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, settings, XMLAssert.te(3, 17, 3, 21, " "), XMLAssert.te(3, 22, 3, 27, " "));
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveSpacesTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveSpacesTest.assertFormat(unformatted, expected, sharedSettings, "test.xml", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveSpacesTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

