/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterJoinCommentLinesTest
extends AbstractCacheBasedTest {
    @Test
    public void testJoinCommentLines() throws BadLocationException {
        String content = "<!--" + System.lineSeparator() + " line 1" + System.lineSeparator() + " " + System.lineSeparator() + " " + System.lineSeparator() + "   line 2" + System.lineSeparator() + " -->";
        String expected = "<!-- line 1 line 2 -->";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterJoinCommentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 4, 1, 1, " "), XMLAssert.te(1, 7, 4, 3, " "), XMLAssert.te(4, 9, 5, 1, " "));
        XMLFormatterJoinCommentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUnclosedEndTagTrailingComment() throws BadLocationException {
        String content = "<root>\n    <a> content </a\n        <!-- comment -->\n </root>";
        String expected = "<root>\n  <a> content </a\n  <!-- comment -->\n</root>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterJoinCommentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 6, 1, 4, "\n  "), XMLAssert.te(1, 19, 2, 8, "\n  "), XMLAssert.te(2, 24, 3, 1, "\n"));
        XMLFormatterJoinCommentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinCommentLinesNested() throws BadLocationException {
        String content = "<a>" + System.lineSeparator() + "  <!--" + System.lineSeparator() + "   line 1" + System.lineSeparator() + "   " + System.lineSeparator() + "   " + System.lineSeparator() + "     line 2" + System.lineSeparator() + "   -->" + System.lineSeparator() + "</a>";
        String expected = "<a>" + System.lineSeparator() + "  <!-- line 1 line 2 -->" + System.lineSeparator() + "</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterJoinCommentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 3, " "), XMLAssert.te(2, 9, 5, 5, " "), XMLAssert.te(5, 11, 6, 3, " "));
        XMLFormatterJoinCommentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testCommentFormatSameLine() throws BadLocationException {
        String content = "<a>" + System.lineSeparator() + " Content" + System.lineSeparator() + "</a> <!-- My   Comment   -->";
        String expected = "<a> Content </a> <!-- My Comment -->";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterJoinCommentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 1, " "), XMLAssert.te(1, 8, 2, 0, " "), XMLAssert.te(2, 12, 2, 15, " "), XMLAssert.te(2, 22, 2, 25, " "));
        XMLFormatterJoinCommentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinCommentLinesLongWrap() throws BadLocationException {
        String content = "<a>\n  Content <!-- comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment --></a>";
        String expected = "<a> Content <!-- comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment comment --></a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterJoinCommentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 2, " "), XMLAssert.te(1, 78, 1, 79, "\n  "), XMLAssert.te(1, 150, 1, 151, "\n  "));
        XMLFormatterJoinCommentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinCommentLinesLongWrapSingleWord() throws BadLocationException {
        String content = "<a>\n<!-- commentcommentcommentcomment commentcommentcommentcomment commentcommentcommentcomment commentcommmentcommentcommentcomment commentcommentcommentscommentcomment commentcommentcommentscommentcomment commentcommentcomments --></a>";
        String expected = "<a>\n  <!-- commentcommentcommentcomment commentcommentcommentcomment\n  commentcommentcommentcomment commentcommmentcommentcommentcomment\n  commentcommentcommentscommentcomment commentcommentcommentscommentcomment\n  commentcommentcomments -->\n</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterJoinCommentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 0, "\n  "), XMLAssert.te(1, 62, 1, 63, "\n  "), XMLAssert.te(1, 128, 1, 129, "\n  "), XMLAssert.te(1, 202, 1, 203, "\n  "), XMLAssert.te(1, 229, 1, 229, "\n"));
        XMLFormatterJoinCommentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testCommentWithRange() throws BadLocationException {
        String content = "<foo>\r\n  <!-- |<bar>|\r\n  </bar>\r\n  -->\r\n</foo>";
        String expected = "<foo>\r\n  <!-- <bar>\r\n  </bar>\r\n  -->\r\n</foo>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterJoinCommentLinesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testCommentWithRange2() throws BadLocationException {
        String content = "<foo>\r\n  |<!-- <bar>\r\n  </bar>\r\n  -->|\r\n<test></test>\r\n</foo>";
        String expected = "<foo>\r\n  <!-- <bar> </bar> -->\r\n<test></test>\r\n</foo>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterJoinCommentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(1, 12, 2, 2, " "), XMLAssert.te(2, 8, 3, 2, " "));
    }

    @Test
    public void testCommentWithRange3() throws BadLocationException {
        String content = "<foo>\r\n\r\n\r\n\r\n  |<!-- <bar>\r\n  </bar>|\r\n  -->\r\n<test></test>\r\n</foo>";
        String expected = "<foo>\r\n\r\n\r\n\r\n  <!-- <bar> </bar> -->\r\n<test></test>\r\n</foo>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterJoinCommentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(4, 12, 5, 2, " "), XMLAssert.te(5, 8, 6, 2, " "));
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterJoinCommentLinesTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterJoinCommentLinesTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

