/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSValue;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDDocument;
import org.eclipse.lemminx.extensions.xsd.contentmodel.XSDDocumentation;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.settings.SchemaDocumentationType;
import org.eclipse.lemminx.utils.StringUtils;

public class CMXSDAttributeDeclaration
implements CMAttributeDeclaration {
    private final XSAttributeUse attributeUse;
    private Map<String, String> valuesDocumentation;
    private String attrDocumentation;
    private SchemaDocumentationType docStrategy;

    public CMXSDAttributeDeclaration(XSAttributeUse attributeUse) {
        this.attributeUse = attributeUse;
    }

    @Override
    public String getName() {
        return this.getAttrDeclaration().getName();
    }

    @Override
    public String getNamespace() {
        return this.getAttrDeclaration().getNamespace();
    }

    @Override
    public String getDefaultValue() {
        XSValue xsValue = this.attributeUse.getValueConstraintValue();
        if (xsValue == null && CMXSDDocument.isBooleanType(this.getAttrDeclaration().getTypeDefinition())) {
            return "false";
        }
        return xsValue != null ? xsValue.getNormalizedValue().toString() : null;
    }

    @Override
    public String getAttributeNameDocumentation(ISharedSettingsRequest request) {
        SchemaDocumentationType currStrategy = request.getSharedSettings().getPreferences().getShowSchemaDocumentationType();
        if (this.docStrategy != currStrategy) {
            this.clearDocumentation();
        } else if (this.attrDocumentation != null) {
            return this.attrDocumentation;
        }
        this.docStrategy = currStrategy;
        XSObjectList annotations = this.getAttributeNameAnnotations();
        boolean markdownSupported = request.canSupportMarkupKind("markdown");
        this.attrDocumentation = new XSDDocumentation(annotations, this.docStrategy, !markdownSupported).getFormattedDocumentation(markdownSupported);
        return this.attrDocumentation;
    }

    private XSObjectList getAttributeNameAnnotations() {
        XSAttributeDeclaration attributeDeclaration = this.getAttrDeclaration();
        XSObjectList annotation = attributeDeclaration.getAnnotations();
        if (annotation != null && annotation.getLength() > 0) {
            return annotation;
        }
        XSSimpleTypeDefinition typeDefinition = attributeDeclaration.getTypeDefinition();
        return typeDefinition != null ? typeDefinition.getAnnotations() : null;
    }

    @Override
    public String getAttributeValueDocumentation(String value, ISharedSettingsRequest request) {
        SchemaDocumentationType currStrategy = request.getSharedSettings().getPreferences().getShowSchemaDocumentationType();
        if (this.docStrategy != currStrategy) {
            this.clearDocumentation();
        }
        this.valuesDocumentation = null;
        this.docStrategy = currStrategy;
        if (this.valuesDocumentation == null) {
            this.valuesDocumentation = this.createValuesDocumentation(request);
        }
        return this.valuesDocumentation.get(value);
    }

    private Map<String, String> createValuesDocumentation(ISharedSettingsRequest request) {
        boolean markdownSupported = request.canSupportMarkupKind("markdown");
        HashMap<String, String> valuesDocumentation = new HashMap<String, String>();
        this.getEnumerationValues().forEach(value -> {
            String documentation = null;
            XSObjectList annotations = this.getAttributeValueAnnotations((String)value);
            if (annotations != null) {
                documentation = new XSDDocumentation(annotations, (String)value, this.docStrategy, !markdownSupported).getFormattedDocumentation(markdownSupported);
            }
            if (StringUtils.isBlank(documentation)) {
                documentation = this.getAttributeNameDocumentation(request);
            }
            valuesDocumentation.put((String)value, documentation);
        });
        return valuesDocumentation;
    }

    private XSObjectList getAttributeValueAnnotations(String value) {
        XSAttributeDeclaration attributeDeclaration = this.getAttrDeclaration();
        XSSimpleTypeDefinition simpleTypeDefinition = attributeDeclaration.getTypeDefinition();
        XSObjectList annotation = CMXSDDocument.getEnumerationAnnotations(simpleTypeDefinition, value);
        if (annotation != null && annotation.getLength() > 0) {
            return annotation;
        }
        return this.getAttributeNameAnnotations();
    }

    private void clearDocumentation() {
        this.valuesDocumentation = null;
        this.attrDocumentation = null;
    }

    @Override
    public boolean isRequired() {
        return this.attributeUse.getRequired();
    }

    XSAttributeDeclaration getAttrDeclaration() {
        return this.attributeUse.getAttrDeclaration();
    }

    @Override
    public Collection<String> getEnumerationValues() {
        XSAttributeDeclaration attributeDeclaration = this.getAttrDeclaration();
        if (attributeDeclaration != null) {
            XSSimpleTypeDefinition typeDefinition = attributeDeclaration.getTypeDefinition();
            return CMXSDDocument.getEnumerationValues(typeDefinition);
        }
        return Collections.emptyList();
    }
}

