/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.SchemaEnabled;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.QuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.PublishDiagnosticsCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.junit.jupiter.api.Test;

public class XMLSchemaDiagnosticsTest {
    @Test
    public void prematureEOFNoErrorReported() throws Exception {
        String xml = " ";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void prematureEOFWithPrologNoErrorReported() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> ";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void cvc_complex_type_2_3() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean>\r\n\t\tXXXXXXXXXXXXX\r\n\t</bean>\r\n</beans>";
        Diagnostic d = XMLAssert.d(3, 2, 3, 15, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3, "Element 'bean' cannot contain text content.\nThe content type is defined as element-only.\n\nCode:");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(3, 2, 3, 15, "")));
    }

    @Test
    public void cvc_complex_type_4() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean>\r\n\t\t<property></property>\r\n\t</bean>\r\n</beans>";
        Diagnostic d = XMLAssert.d(3, 3, 3, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_4, "Attribute:\n - name\nis required in element:\n - property\n\nCode:");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(3, 11, 3, 11, " name=\"\"")));
    }

    @Test
    public void cvc_type_4_Multiple_attributes() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/invoice.xsd\">\r\n  <date>2017-11-30</date>\r\n  <number>2</number>\r\n  <products>\r\n  \t<product />\r\n  </products>\r\n  <payments>\r\n  \t<payment amount=\"1\" method=\"credit\"/>\r\n  </payments>\r\n</invoice>";
        Diagnostic d2 = XMLAssert.d(6, 4, 6, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_4, "Attribute:\n - description\nis required in element:\n - product\n\nCode:");
        Diagnostic d1 = XMLAssert.d(6, 4, 6, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_4, "Attribute:\n - price\nis required in element:\n - product\n\nCode:");
        XMLAssert.testDiagnosticsFor(xml, d1, d2);
        XMLAssert.testCodeActionsFor(xml, d1, XMLAssert.ca(d1, XMLAssert.te(6, 11, 6, 11, " price=\"\" description=\"\"")));
    }

    @Test
    public void cvc_complex_type_2_4_a() throws Exception {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<XXX></XXX>\r\n</project>";
        String message = "Invalid element name:\n - XXX\n\nOne of the following is expected:\n - modelVersion\n - parent\n - groupId\n - artifactId\n - version\n - packaging\n - name\n - description\n - url\n - inceptionYear\n - organization\n - licenses\n - developers\n - contributors\n - mailingLists\n - prerequisites\n - modules\n - scm\n - issueManagement\n - ciManagement\n - distributionManagement\n - properties\n - dependencyManagement\n - dependencies\n - repositories\n - pluginRepositories\n - build\n - reports\n - reporting\n - profiles\n\nError indicated by:\n {http://maven.apache.org/POM/4.0.0}\nwith code:";
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, XMLAssert.d(3, 2, 3, 5, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_a, message));
    }

    @Test
    public void cvc_complex_type_2_4_a_Disabled_Validation() throws Exception {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<XXX></XXX>\r\n</project>";
        XMLSchemaDiagnosticsTest.testDiagnosticsDisabledValidation(xml);
    }

    @Test
    public void cvc_complex_type_2_4_d() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean>\r\n\t\t<description>\r\n\t\t\t<XXXX />\r\n\t\t</description>\r\n\t</bean>\r\n</beans>";
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, XMLAssert.d(4, 4, 4, 8, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_d));
    }

    @Test
    public void cvc_complex_type_2_4_f() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/tag.xsd\">\r\n  <tag></tag>\r\n  <optional></optional>\r\n  <optional></optional>\r\n  <optional></optional>\r\n</root>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(7, 3, 7, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_f));
    }

    @Test
    public void cvc_type_3_1_1() throws Exception {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n<modelVersion XXXX=\"\" ></modelVersion></project>";
        Diagnostic d = XMLAssert.d(3, 14, 3, 21, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_1);
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(3, 14, 3, 21, "")));
    }

    @Test
    public void cvc_complex_type_3_2_2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean XXXX=\"\" >\r\n\t</bean>              \r\n</beans>";
        Diagnostic d = XMLAssert.d(2, 7, 2, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_3_2_2);
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 7, 2, 14, "")));
    }

    @Test
    public void cvc_attribute_3() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean autowire=\"ERROR\" />\r\n</beans>";
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, XMLAssert.d(2, 16, 2, 23, (IXMLErrorCode)XMLSchemaErrorCode.cvc_enumeration_valid), XMLAssert.d(2, 16, 2, 23, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3));
    }

    @Test
    public void cvc_type_3_1_3() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/invoice.xsd\">\r\n  <date>2017-11-30_INVALID</date>\r\n  <number>0</number>\r\n  <products>\r\n  \t<product price=\"1\" description=\"\"/>\r\n  </products>\r\n  <payments>\r\n  \t<payment amount=\"1\" method=\"credit\"/>\r\n  </payments>\r\n</invoice>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(3, 8, 3, 26, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_1), XMLAssert.d(3, 8, 3, 26, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3));
    }

    @Test
    public void cvc_enumeration_validOnAttribute() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/invoice.xsd\">\r\n  <date>2017-11-30</date>\r\n  <number>0</number>\r\n  <products>\r\n  \t<product price=\"1\" description=\"\"/>\r\n  </products>\r\n  <payments>\r\n  \t<payment amount=\"1\" method=\"credit_invalid\"/>\r\n  </payments>\r\n</invoice>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(9, 30, 9, 46, (IXMLErrorCode)XMLSchemaErrorCode.cvc_enumeration_valid), XMLAssert.d(9, 30, 9, 46, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3));
    }

    @Test
    public void cvc_enumeration_validOnText() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     xmlns=\"team_namespace\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace src/test/resources/xsd/team.xsd \">\r\n\t<member\r\n\t       name=\"John\"\r\n\t       badgeNumber=\"1\"\r\n\t       role=\"architect\">\r\n\t\t<skills>\r\n\t\t\t<skill>XXXXX</skill>\r\n\t\t</skills> \r\n\t\t<focus>\r\n\t\t\t<server\r\n\t\t\t       language=\"Java\" />\r\n\t\t</focus>\r\n\t</member>\r\n</team>";
        Diagnostic d = XMLAssert.d(10, 10, 10, 15, (IXMLErrorCode)XMLSchemaErrorCode.cvc_enumeration_valid);
        XMLAssert.testDiagnosticsFor(xml, d, XMLAssert.d(10, 10, 10, 15, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3));
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(10, 10, 10, 15, "Java")), XMLAssert.ca(d, XMLAssert.te(10, 10, 10, 15, "Node")), XMLAssert.ca(d, XMLAssert.te(10, 10, 10, 15, "XML")));
    }

    @Test
    public void cvc_datatype_valid_1_2_1OnAttributeValue() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/invoice.xsd\">\r\n  <date>2017-11-30</date>\r\n  <number>5235</number> \r\n  <products> \r\n    <product description=\"laptop\" price=\"700.00_INVALID\"/>  \r\n    <product description=\"mouse\" price=\"30.00\" />\r\n  </products> \r\n  <payments>\r\n    <payment amount=\"770.00\" method=\"credit\"/>\r\n  </payments>\r\n</invoice> ";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(6, 40, 6, 56, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_1), XMLAssert.d(6, 40, 6, 56, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3));
    }

    @Test
    public void cvc_datatype_valid_1_2_1OnText() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/invoice.xsd\">\r\n  <date>2017-11-30</date>\r\n  <number>5235_INVALID</number> \r\n  <products> \r\n    <product description=\"laptop\" price=\"700.00\"/>  \r\n    <product description=\"mouse\" price=\"30.00\" />\r\n  </products> \r\n  <payments>\r\n    <payment amount=\"770.00\" method=\"credit\"/>\r\n  </payments>\r\n</invoice> ";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(4, 10, 4, 22, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_1), XMLAssert.d(4, 10, 4, 22, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3));
    }

    @Test
    public void cvc_datatype_valid_1_2_1_TextOnlyWithWhitespace() throws Exception {
        String xml = "<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n    xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/integerElement.xsd\">\r\n\r\n    TEXT\r\n\r\n</a>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(3, 4, 3, 8, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_1), XMLAssert.d(3, 4, 3, 8, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3));
    }

    @Test
    public void cvc_datatype_valid_1_2_1_OneElement() throws Exception {
        String xml = "<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n    xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/integerElement.xsd\">\r\n\r\n    <b></b>\r\n\r\n</a>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 2, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_2), XMLAssert.d(3, 4, 3, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_1), XMLAssert.d(3, 4, 3, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3));
    }

    @Test
    public void cvc_datatype_valid_1_2_1_TwoElements() throws Exception {
        String xml = "<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n    xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/integerElement.xsd\">\r\n\r\n    <b></b>\r\n    <c></c>\r\n\r\n</a>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 2, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_2), XMLAssert.d(3, 4, 3, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_1), XMLAssert.d(3, 4, 3, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3));
    }

    @Test
    public void cvc_datatype_valid_1_2_3OnText() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<dresssize xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/dressSize.xsd\">\r\n               XXX           \r\n</dresssize>  ";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(3, 15, 3, 18, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_3), XMLAssert.d(3, 15, 3, 18, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3));
    }

    @Test
    public void cvc_datatype_valid_1_2_3Empty() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<dresssize xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/dressSize.xsd\"></dresssize>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(1, 1, 1, 10, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_3), XMLAssert.d(1, 1, 1, 10, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3));
    }

    @Test
    public void cvc_maxLength_validOnAttribute() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"team_namespace\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace src/test/resources/xsd/team.xsd \">\r\n\t<member\r\n\t       name=\"John\"\r\n\t       badgeNumber=\"1\"\r\n\t       role=\"architect\">\r\n\t\t<skills>\r\n\t\t\t<skill>Java</skill>\r\n\t\t</skills> \r\n\t\t<focus>\r\n\t\t\t<server\r\n\t\t\t       language=\"Java\" />\r\n\t\t</focus>\r\n\t</member>\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 10, 2, 29, (IXMLErrorCode)XMLSchemaErrorCode.cvc_maxlength_valid), XMLAssert.d(2, 10, 2, 29, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3));
    }

    @Test
    public void cvc_complex_type_2_1() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n      xmlns=\"http://www.springframework.org/schema/beans\"\r\n      xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\"\r\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<alias name=\"\" alias=\"\" >XXXX</alias>\r\n</beans>";
        Diagnostic d = XMLAssert.d(5, 26, 5, 30, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_1);
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(5, 25, 5, 38, "/>")));
    }

    @Test
    public void cvc_complex_type_2_1_SelfClosing() throws Exception {
        String xml = "<money xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/money.xsd\" currency=\"euros\"> </money>";
        Diagnostic d = XMLAssert.d(0, 143, 0, 144, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_1);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 142, 0, 152, "/>")));
    }

    @Test
    public void cvc_complex_type_2_1WithLinefeed() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n      xmlns=\"http://www.springframework.org/schema/beans\"\r\n      xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\"\r\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<alias name=\"\" alias=\"\" >\r\n   \r\n</alias>\r\n</beans>";
        Diagnostic d = XMLAssert.d(5, 26, 7, 0, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_1);
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(5, 25, 7, 8, "/>")));
    }

    @Test
    public void cvc_pattern_valid() throws Exception {
        String xml = "<Annotation\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/pattern.xsd\"\r\n\tTerm=\"X\"></Annotation>";
        Diagnostic patternValid = XMLAssert.d(3, 6, 3, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_pattern_valid);
        Diagnostic cvcAttribute3 = XMLAssert.d(3, 6, 3, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3);
        XMLAssert.testDiagnosticsFor(xml, patternValid, cvcAttribute3);
    }

    @Test
    public void cvc_pattern_valid_With_Buffer() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>\r\n<cpr xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n     xsi:noNamespaceSchemaLocation=\"https://www.dgai.de/cpr/schema/ev/cpr-ev-2.0.xsd\">\r\n    <cprev>\r\n        <VERSION>2.0</VERSION>\r\n        <DATUM>2019-08-09</DATUM>\r\n        <STOKENN>FIX_ERROR_RANGE_HERE</STOKENN>\r\n    </cprev>\r\n</cpr>";
        Diagnostic patternValid = XMLAssert.d(6, 17, 6, 37, (IXMLErrorCode)XMLSchemaErrorCode.cvc_pattern_valid);
        Diagnostic cvcType313 = XMLAssert.d(6, 17, 6, 37, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3);
        Diagnostic cvcType24b = XMLAssert.d(3, 5, 3, 10, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_b);
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, patternValid, cvcType313, cvcType24b);
    }

    @Test
    public void issue217() {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Edmx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">\r\n  \r\n</edmx:Edmx>";
        Diagnostic d = XMLAssert.d(1, 1, 1, 10, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_b, "Child elements are missing from element:\n - edmx:Edmx\n\nThe following elements are expected:\n - Reference\n - DataServices\n\nError indicated by\n {http://docs.oasis-open.org/odata/ns/edmx\":Reference, \"http://docs.oasis-open.org/odata/ns/edmx}\nwith code:");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, d);
    }

    @Test
    public void cvc_type_3_2_1() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/invoice.xsd\">\r\n  <date xsi:nil=\"true\">2017-11-30</date>\r\n  <number>0</number>\r\n  <products>\r\n  \t<product price=\"1\" description=\"\"/>\r\n  </products>\r\n  <payments>\r\n  \t<payment amount=\"1\" method=\"credit\"/>\r\n  </payments>\r\n</invoice>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(3, 23, 3, 33, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_3_2_1));
    }

    @Test
    public void cvc_type_3_1_2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/invoice.xsd\">\r\n  <date>2017-11-30</date>\r\n  <number><a></a></number>\r\n  <products>\r\n  \t<product price=\"1\" description=\"\"/>\r\n  </products>\r\n  <payments>\r\n  \t<payment amount=\"1\" method=\"credit\"/>\r\n  </payments>\r\n</invoice>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(4, 3, 4, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_2), XMLAssert.d(4, 10, 4, 17, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_1), XMLAssert.d(4, 10, 4, 17, (IXMLErrorCode)XMLSchemaErrorCode.cvc_type_3_1_3));
    }

    @Test
    public void testSrcElement3() throws Exception {
        String xml = "<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/srcElement3.xsd\">\r\n\t<b></b>\r\n</a>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 2, (IXMLErrorCode)XMLSchemaErrorCode.src_element_3));
    }

    @Test
    public void schema_reference_4_withSchemaLocation() {
        String xml = "<IODevice xmlns=\"http://www.io-link.com/IODD/2010/10\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  xsi:schemaLocation=\"http://www.io-link.com/IODD/2010/10 IODD1.1.xsd\">\r\n\t</IODevice>";
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, XMLAssert.d(1, 58, 1, 69, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4), XMLAssert.d(0, 1, 0, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a));
    }

    @Test
    public void schema_reference_4_schemaLocationMultipleOneWrong() {
        String xml = "<root:root\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxmlns:root=\"http://example.org/schema/root\"\nxmlns:other=\"http://example.org/schema/other\"\nxsi:schemaLocation=\"http://example.org/schema/root root.xsd http://example.org/schema/other other.xsd\">\n<other:other />\n</root:root>";
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, XMLAssert.d(4, 92, 4, 101, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4), XMLAssert.d(5, 1, 5, 12, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_c));
    }

    @Test
    public void schema_reference_4_schemaLocationMultipleBothWrong() {
        String xml = "<root:root\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxmlns:root=\"http://example.org/schema/robot\"\nxmlns:other=\"http://example.org/schema/other\"\nxsi:schemaLocation=\"http://example.org/schema/robot robot.xsd http://example.org/schema/other other.xsd\">\n<other:other />\n</root:root>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(4, 52, 4, 61, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4), XMLAssert.d(0, 1, 0, 10, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a), XMLAssert.d(4, 94, 4, 103, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4));
    }

    @Test
    public void fuzzyElementNameCodeActionTest() throws Exception {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" \r\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n    <modules>\r\n      <bodule></bodule>\r\n    </modules>\r\n</project>";
        Diagnostic diagnostic = XMLAssert.d(4, 7, 4, 13, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_a, "Invalid element name:\n - bodule\n\nOne of the following is expected:\n - module\n\nError indicated by:\n {http://maven.apache.org/POM/4.0.0}\nwith code:");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, diagnostic);
        this.testCodeActionsWithCatalogFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(4, 7, 4, 13, "module"), XMLAssert.te(4, 16, 4, 22, "module")));
    }

    private void testCodeActionsWithCatalogFor(String xml, Diagnostic diagnostic, CodeAction ... expected) throws BadLocationException {
        XMLAssert.testCodeActionsFor(xml, diagnostic, "src/test/resources/catalogs/catalog.xml", expected);
    }

    @Test
    public void fuzzyElementNamesWithOtherOptionsCodeActionTest() throws Exception {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" \r\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n    <ciManagement>\r\n      <XXXXXXXXX></XXXXXXXXX>\r\n    </ciManagement>\r\n</project>";
        Diagnostic diagnostic = XMLAssert.d(4, 7, 4, 16, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_a, "Invalid element name:\n - XXXXXXXXX\n\nOne of the following is expected:\n - system\n - url\n - notifiers\n\nError indicated by:\n {http://maven.apache.org/POM/4.0.0}\nwith code:");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, diagnostic);
        this.testCodeActionsWithCatalogFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(4, 7, 4, 16, "notifiers"), XMLAssert.te(4, 19, 4, 28, "notifiers")), XMLAssert.ca(diagnostic, XMLAssert.te(4, 7, 4, 16, "system"), XMLAssert.te(4, 19, 4, 28, "system")), XMLAssert.ca(diagnostic, XMLAssert.te(4, 7, 4, 16, "url"), XMLAssert.te(4, 19, 4, 28, "url")));
    }

    @Test
    public void elementFormDefaultUnqualified() throws Exception {
        String xml = "<foo xmlns=\"http://foo\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://foo foo-unqualified.xsd\">\r\n\t<bar />\r\n</foo>";
        Diagnostic diagnostic = XMLAssert.d(1, 2, 1, 5, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_a, "Invalid element name:\n - bar\n\nOne of the following is expected:\n - bar\n\nError indicated by:\n {http://foo}\nwith code:");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, diagnostic);
    }

    @Test
    public void fuzzyElementNamesWithPrefix() throws Exception {
        String xml = "<beans xmlns=\"http://www.springframework.org/schema/beans\"\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xmlns:camel=\"http://camel.apache.org/schema/spring\"\n        xsi:schemaLocation=\"\n           http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\n           http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\"> \n    <camel:beani></camel:beani>\n</beans>";
        Diagnostic diagnostic = XMLAssert.d(6, 5, 6, 16, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_c, "cvc-complex-type.2.4.c: The matching wildcard is strict, but no declaration can be found for element 'camel:beani'.");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, diagnostic);
        this.testCodeActionsWithCatalogFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(6, 11, 6, 16, "bean"), XMLAssert.te(6, 25, 6, 30, "bean")), XMLAssert.ca(diagnostic, XMLAssert.te(6, 11, 6, 16, "beanio"), XMLAssert.te(6, 25, 6, 30, "beanio")));
    }

    @Test
    public void fuzzyElementNamesWithPrefixAndNoMatch() throws Exception {
        String xml = "<schemaB:BRootElement \n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n      xsi:schemaLocation=\"http://schemaA src/test/resources/xsd/fuzzyCodeAction/FuzzySchemaA.xsd http://schemaB src/test/resources/xsd/fuzzyCodeAction/FuzzySchemaB.xsd\" \n      xmlns:schemaA=\"http://schemaA\" \n      xmlns:schemaB=\"http://schemaB\">\n   <schemaA:XXXXX></schemaA:XXXXX>\n</schemaB:BRootElement>";
        Diagnostic diagnostic = XMLAssert.d(5, 4, 5, 17, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_c, "cvc-complex-type.2.4.c: The matching wildcard is strict, but no declaration can be found for element 'schemaA:XXXXX'.");
        XMLAssert.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(5, 12, 5, 17, "AElement1"), XMLAssert.te(5, 28, 5, 33, "AElement1")), XMLAssert.ca(diagnostic, XMLAssert.te(5, 12, 5, 17, "AElement2"), XMLAssert.te(5, 28, 5, 33, "AElement2")));
    }

    @Test
    public void fuzzyElementMemberValueCodeActionTest() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<dress \r\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\nxsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/dressSize.xsd\"\r\nsize=\"larg\"/>";
        Diagnostic diagnostic1 = XMLAssert.d(4, 5, 4, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3, "cvc-attribute.3: The value 'larg' of attribute 'size' on element 'dress' is not valid with respect to its type, 'SizeType'.");
        XMLAssert.testCodeActionsFor(xml, diagnostic1, XMLAssert.ca(diagnostic1, XMLAssert.te(4, 6, 4, 10, "large")), XMLAssert.ca(diagnostic1, XMLAssert.te(4, 6, 4, 10, "x-large")));
    }

    @Test
    public void cvc_complex_type_2_2_withElement() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<int xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://integer\" xsi:schemaLocation=\"http://integer src/test/resources/xsd/namedInteger.xsd\">\n    <int>42</int>\n</int>";
        Diagnostic diagnostic = XMLAssert.d(1, 1, 1, 4, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_2, "cvc-complex-type.2.2: Element 'int' must have no element [children], and the value must be valid.");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, diagnostic);
    }

    @Test
    public void cvc_complex_type_2_2_withText() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<int xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://integer\" xsi:schemaLocation=\"http://integer src/test/resources/xsd/namedInteger.xsd\">\n    Bob</int>";
        Diagnostic diagnosticBob = XMLAssert.d(2, 4, 2, 7, (IXMLErrorCode)XMLSchemaErrorCode.cvc_datatype_valid_1_2_1, "Content of type 'integer' is expected.\n\nThe following content is not a valid type:\n 'Bob'\n\nCode:");
        Diagnostic diagnostic_cvc_2_2 = XMLAssert.d(1, 1, 1, 4, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_2, "cvc-complex-type.2.2: Element 'int' must have no element [children], and the value must be valid.");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, diagnosticBob, diagnostic_cvc_2_2);
    }

    @Test
    public void testTargetNamespace_1Normal() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<?xml-model href=\"src/test/resources/xsd/two-letter-name.xsd\"?>\n<two-letter-name xmlns=\"BAD_NS\">Io</two-letter-name>";
        Diagnostic targetNamespace = XMLAssert.d(2, 23, 2, 31, (IXMLErrorCode)XMLSchemaErrorCode.TargetNamespace_1, "TargetNamespace.1: Expecting namespace 'BAD_NS', but the target namespace of the schema document is 'http://two-letter-name'.");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, targetNamespace, XMLAssert.d(2, 1, 2, 16, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a, "cvc-elt.1.a: Cannot find the declaration of element 'two-letter-name'."));
        XMLAssert.testCodeActionsFor(xml, targetNamespace, XMLAssert.ca(targetNamespace, XMLAssert.te(2, 23, 2, 31, "\"http://two-letter-name\"")));
    }

    @Test
    public void testTargetNamespace_1ShortNS() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<?xml-model href=\"src/test/resources/xsd/two-letter-name.xsd\"?>\n<two-letter-name xmlns=\"_\">Io</two-letter-name>";
        Diagnostic targetNamespace = XMLAssert.d(2, 23, 2, 26, (IXMLErrorCode)XMLSchemaErrorCode.TargetNamespace_1, "TargetNamespace.1: Expecting namespace '_', but the target namespace of the schema document is 'http://two-letter-name'.");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, targetNamespace, XMLAssert.d(2, 1, 2, 16, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a, "cvc-elt.1.a: Cannot find the declaration of element 'two-letter-name'."));
        XMLAssert.testCodeActionsFor(xml, targetNamespace, XMLAssert.ca(targetNamespace, XMLAssert.te(2, 23, 2, 26, "\"http://two-letter-name\"")));
    }

    @Test
    public void testTargetNamespace_1SingleQuotes() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<?xml-model href=\"src/test/resources/xsd/two-letter-name.xsd\"?>\n<two-letter-name xmlns=\"_\">Io</two-letter-name>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        Diagnostic targetNamespace = XMLAssert.d(2, 23, 2, 26, (IXMLErrorCode)XMLSchemaErrorCode.TargetNamespace_1, "TargetNamespace.1: Expecting namespace '_', but the target namespace of the schema document is 'http://two-letter-name'.");
        XMLAssert.testCodeActionsFor(xml, targetNamespace, settings, XMLAssert.ca(targetNamespace, XMLAssert.te(2, 23, 2, 26, "'http://two-letter-name'")));
    }

    @Test
    public void testTargetNamespace_2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<?xml-model href=\"src/test/resources/xsd/two-letter-name.xsd\"?>\n<two-letter-name>Io</two-letter-name>";
        Diagnostic targetNamespace = XMLAssert.d(2, 1, 2, 16, (IXMLErrorCode)XMLSchemaErrorCode.TargetNamespace_2, "TargetNamespace.2: Expecting no namespace, but the schema document has a target namespace of 'http://two-letter-name'.");
        XMLSchemaDiagnosticsTest.testDiagnosticsWithCatalogFor(xml, targetNamespace, XMLAssert.d(2, 1, 2, 16, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a, "cvc-elt.1.a: Cannot find the declaration of element 'two-letter-name'."));
        XMLAssert.testCodeActionsFor(xml, targetNamespace, XMLAssert.ca(targetNamespace, XMLAssert.te(2, 16, 2, 16, " xmlns=\"http://two-letter-name\"")));
    }

    @Test
    public void testTargetNamespace_2SingleQuotes() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<?xml-model href=\"src/test/resources/xsd/two-letter-name.xsd\"?>\n<two-letter-name>Io</two-letter-name>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        Diagnostic targetNamespace = XMLAssert.d(2, 1, 2, 16, (IXMLErrorCode)XMLSchemaErrorCode.TargetNamespace_2, "TargetNamespace.2: Expecting no namespace, but the schema document has a target namespace of 'http://two-letter-name'.");
        XMLAssert.testCodeActionsFor(xml, targetNamespace, settings, XMLAssert.ca(targetNamespace, XMLAssert.te(2, 16, 2, 16, " xmlns='http://two-letter-name'")));
    }

    @Test
    public void localSchemaFileMissingCodeAction() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"/sala'd.xsd\">\n</invoice>";
        Diagnostic missingSchemaDiagnostic = XMLAssert.d(2, 32, 45, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4);
        missingSchemaDiagnostic.setMessage("schema_reference.4: Failed to read schema document 'file:///sala'd.xsd', because 1) could not find the document; 2) the document could not be read; 3) the root element of the document is not <xsd:schema>.");
        Diagnostic eltDiagnostic = XMLAssert.d(1, 1, 8, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a);
        eltDiagnostic.setMessage("cvc-elt.1.a: Cannot find the declaration of element 'invoice'.");
        XMLAssert.testDiagnosticsFor(xml, missingSchemaDiagnostic, eltDiagnostic);
        SharedSettings settings = new SharedSettings();
        WorkspaceClientCapabilities workspace = new WorkspaceClientCapabilities();
        WorkspaceEditCapabilities workspaceEdit = new WorkspaceEditCapabilities();
        workspaceEdit.setResourceOperations(Arrays.asList("create"));
        workspace.setWorkspaceEdit(workspaceEdit);
        settings.getWorkspaceSettings().setCapabilities(workspace);
        XMLAssert.testCodeActionsFor(xml, missingSchemaDiagnostic, settings, XMLAssert.ca(missingSchemaDiagnostic, XMLAssert.createFile("file:///sala'd.xsd", false), XMLAssert.teOp("file:///sala'd.xsd", 0, 0, 0, 0, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"invoice\" type=\"xs:string\" />" + System.lineSeparator() + "</xs:schema>")));
    }

    @Test
    public void localSchemaFileMissingCodeActionNotSupported() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"/salad.xsd\">\n</invoice>";
        Diagnostic missingSchema = XMLAssert.d(2, 32, 44, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4);
        missingSchema.setMessage("schema_reference.4: Failed to read schema document 'file:///salad.xsd', because 1) could not find the document; 2) the document could not be read; 3) the root element of the document is not <xsd:schema>.");
        Diagnostic eltDiagnostic = XMLAssert.d(1, 1, 8, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a);
        eltDiagnostic.setMessage("cvc-elt.1.a: Cannot find the declaration of element 'invoice'.");
        XMLAssert.testDiagnosticsFor(xml, missingSchema, eltDiagnostic);
        XMLAssert.testCodeActionsFor(xml, missingSchema, new CodeAction[0]);
    }

    @Test
    public void cvc_complex_type_2_3_singleLine() throws BadLocationException {
        String xml = "<foo\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/close-tag-type.xsd\">\n  <bar>/bar></bar>\n</foo>";
        Diagnostic diagnostic = XMLAssert.d(3, 7, 12, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3);
        XMLAssert.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(3, 7, 3, 12, "")));
    }

    @Test
    public void cvc_complex_type_2_3_multiLine() throws BadLocationException {
        String xml = "<foo\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/close-tag-type.xsd\">\n  <bar>/bar>\nbarbarbar</bar>\n</foo>";
        Diagnostic diagnostic = XMLAssert.d(3, 7, 12, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3);
        XMLAssert.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(3, 7, 3, 12, "")));
    }

    @Test
    public void cvc_complex_type_2_3_singleLineSpaces() throws BadLocationException {
        String xml = "<foo\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/close-tag-type.xsd\">\n  <bar>    \t/bar> \t \t</bar>\n</foo>";
        Diagnostic diagnostic = XMLAssert.d(3, 12, 17, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3);
        XMLAssert.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(3, 12, 3, 17, "")));
    }

    @Test
    public void cvc_complex_type_2_3_singleLineCData() throws BadLocationException {
        String xml = "<foo\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/close-tag-type.xsd\">\n  <bar> <![CDATA[ bar ]]> </bar>\n</foo>";
        Diagnostic diagnostic = XMLAssert.d(3, 18, 21, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3);
        XMLAssert.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(3, 18, 3, 21, "")));
    }

    @Test
    public void cvc_complex_type_2_3_multiLineCData() throws BadLocationException {
        String xml = "<foo\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/close-tag-type.xsd\">\n  <bar> <![CDATA[ bar\n   hi ]]> </bar>\n</foo>";
        Diagnostic diagnostic = XMLAssert.d(3, 18, 21, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3);
        XMLAssert.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(3, 18, 3, 21, "")));
    }

    @Test
    public void cvc_complex_type_2_3_blankCData() throws BadLocationException {
        String xml = "<foo\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/close-tag-type.xsd\">\n  <bar> <![CDATA[  ]]> </bar>\n</foo>";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void cvc_complex_type_2_3_blankCDataWithTextAfter() throws BadLocationException {
        String xml = "<foo\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/close-tag-type.xsd\">\n  <bar> <![CDATA[  ]]> TextContent </bar>\n</foo>";
        Diagnostic diagnostic = XMLAssert.d(3, 23, 34, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3);
        XMLAssert.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(3, 23, 3, 34, "")));
    }

    @Test
    public void cvc_complex_type_2_3_elementBeforeText() throws BadLocationException {
        String xml = "<foo\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/close-tag-type.xsd\">\n  <bar /> TextContent <bar></bar>\n</foo>";
        Diagnostic diagnostic = XMLAssert.d(3, 10, 21, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3);
        XMLAssert.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(3, 10, 3, 21, "")));
    }

    @Test
    public void diagnosticRelatedInformationWithXMLModelSchemaProblem() throws Exception {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationSettings validationSettings = new XMLValidationSettings();
        validationSettings.setCapabilities(new PublishDiagnosticsCapabilities(Boolean.valueOf(true)));
        settings.setValidation(validationSettings);
        String xml = "<?xml-model href=\"xsd/foo-invalid-schema.xsd\" ?>\r\n<foo>\r\n\t<barX></barX> \r\n</foo>";
        Diagnostic diagnostic = new Diagnostic(XMLAssert.r(0, 17, 0, 45), "There is '1' error in 'foo-invalid-schema.xsd'.", DiagnosticSeverity.Error, "xml");
        diagnostic.setRelatedInformation(new ArrayList());
        String xsdFileURI = XMLSchemaDiagnosticsTest.getGrammarFileURI("foo-invalid-schema.xsd");
        diagnostic.getRelatedInformation().add(new DiagnosticRelatedInformation(XMLAssert.l(xsdFileURI, XMLAssert.r(1, 71, 1, 73)), ""));
        Diagnostic diagnosticBasedOnXSD = new Diagnostic(XMLAssert.r(2, 2, 2, 6), "Invalid element name:\n - barX\n\nOne of the following is expected:\n - bar\n\nError indicated by:\n {the schema}\nwith code:", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_complex_type_2_4_a.getCode());
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnXSD);
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnXSD);
    }

    @Test
    public void diagnosticRelatedInformationWithNoNamespaceSchemaLocationSchemaProblem() throws Exception {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationSettings validationSettings = new XMLValidationSettings();
        validationSettings.setCapabilities(new PublishDiagnosticsCapabilities(Boolean.valueOf(true)));
        settings.setValidation(validationSettings);
        String xml = "<foo xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n\t xsi:noNamespaceSchemaLocation=\"xsd/foo-invalid-schema.xsd\">\r\n\t<barX />\r\n</foo>";
        Diagnostic diagnostic = new Diagnostic(XMLAssert.r(1, 32, 1, 60), "There is '1' error in 'foo-invalid-schema.xsd'.", DiagnosticSeverity.Error, "xml");
        diagnostic.setRelatedInformation(new ArrayList());
        String xsdFileURI = XMLSchemaDiagnosticsTest.getGrammarFileURI("foo-invalid-schema.xsd");
        diagnostic.getRelatedInformation().add(new DiagnosticRelatedInformation(XMLAssert.l(xsdFileURI, XMLAssert.r(1, 71, 1, 73)), ""));
        Diagnostic diagnosticBasedOnXSD = new Diagnostic(XMLAssert.r(2, 2, 2, 6), "Invalid element name:\n - barX\n\nOne of the following is expected:\n - bar\n\nError indicated by:\n {the schema}\nwith code:", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_complex_type_2_4_a.getCode());
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnXSD);
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnXSD);
    }

    @Test
    public void diagnosticRelatedInformationWithNoNamespaceSchemaLocationSyntaxProblem() throws Exception {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationSettings validationSettings = new XMLValidationSettings();
        validationSettings.setCapabilities(new PublishDiagnosticsCapabilities(Boolean.valueOf(true)));
        settings.setValidation(validationSettings);
        String xml = "<foo xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n\t xsi:noNamespaceSchemaLocation=\"xsd/foo-invalid-syntax.xsd\">\r\n\t<bar />\r\n</foo>";
        Diagnostic diagnostic = new Diagnostic(XMLAssert.r(1, 32, 1, 60), "There is '1' error in 'foo-invalid-syntax.xsd'.", DiagnosticSeverity.Error, "xml");
        diagnostic.setRelatedInformation(new ArrayList());
        String xsdFileURI = XMLSchemaDiagnosticsTest.getGrammarFileURI("foo-invalid-syntax.xsd");
        diagnostic.getRelatedInformation().add(new DiagnosticRelatedInformation(XMLAssert.l(xsdFileURI, XMLAssert.r(1, 1, 1, 54)), ""));
        Diagnostic diagnosticBasedOnXSD = new Diagnostic(XMLAssert.r(0, 1, 0, 4), "cvc-elt.1.a: Cannot find the declaration of element 'foo'.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_elt_1_a.getCode());
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnXSD);
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnXSD);
    }

    @Test
    public void diagnosticRelatedInformationWithSchemaLocationSyntaxProblem() throws Exception {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationSettings validationSettings = new XMLValidationSettings();
        validationSettings.setCapabilities(new PublishDiagnosticsCapabilities(Boolean.valueOf(true)));
        settings.setValidation(validationSettings);
        String xml = "<foo\r\n\t\txmlns=\"http://foo\"\r\n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\t\txsi:schemaLocation=\"http://foo xsd/foo-ns-invalid-syntax.xsd\">\r\n\t<bar />\r\n</foo>";
        Diagnostic diagnostic = new Diagnostic(XMLAssert.r(3, 33, 3, 62), "There is '1' error in 'foo-ns-invalid-syntax.xsd'.", DiagnosticSeverity.Error, "xml");
        diagnostic.setRelatedInformation(new ArrayList());
        String xsdFileURI = XMLSchemaDiagnosticsTest.getGrammarFileURI("foo-ns-invalid-syntax.xsd");
        diagnostic.getRelatedInformation().add(new DiagnosticRelatedInformation(XMLAssert.l(xsdFileURI, XMLAssert.r(1, 1, 4, 29)), ""));
        Diagnostic diagnosticBasedOnXSD1 = new Diagnostic(XMLAssert.r(1, 8, 1, 20), "TargetNamespace.1: Expecting namespace 'http://foo', but the target namespace of the schema document is 'xs:element name=\"foo\">'.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.TargetNamespace_1.getCode());
        Diagnostic diagnosticBasedOnXSD2 = new Diagnostic(XMLAssert.r(0, 1, 0, 4), "cvc-elt.1.a: Cannot find the declaration of element 'foo'.", DiagnosticSeverity.Error, "xml", XMLSchemaErrorCode.cvc_elt_1_a.getCode());
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnXSD1, diagnosticBasedOnXSD2);
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnXSD1, diagnosticBasedOnXSD2);
    }

    @Test
    public void diagnosticsWithCatalogAndXSDInclude() throws BadLocationException {
        String xml = "<document xmlns=\"http://foobar.com/test\">\r\n\t<page></page>\r\n</document>";
        Diagnostic diagnostic = XMLAssert.d(1, 2, 1, 6, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_b);
        XMLAssert.testDiagnosticsFor(xml, "src/test/resources/catalogs/include/catalog-include.xml", diagnostic);
    }

    @Test
    public void noHintSchemaLocationForRootElement() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<setup:Configuration \r\n    xmi:version=\"2.0\"\r\n    xmlns:xmi=\"http://www.omg.org/XMI\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n    xmlns:setup=\"http://www.eclipse.org/oomph/setup/1.0\"\r\n    xmlns:setup.p2=\"http://www.eclipse.org/oomph/setup/p2/1.0\"\r\n    xmlns:workbench=\"http://www.eclipse.org/oomph/setup/workbench/1.0\"\r\n    xsi:schemaLocation=\"http://www.eclipse.org/oomph/setup/workbench/1.0 http://git.eclipse.org/c/oomph/org.eclipse.oomph.git/plain/setups/models/Workbench.ecore\"\r\n    label=\"Gael Eclipse Installation\"> \r\n  <installation name=\"com.github.glhez.eclipse.install\" label=\"Gael Eclipse Installation Installation\">\r\n    <setupTask xsi:type=\"setup.p2:P2Task\" label=\"Oomph Setup Task\">\r\n      <requirement name=\"org.eclipse.oomph.setup.feature.group\"/>\r\n      <repository url=\"${oomph.update.url}\"/>\r\n    </setupTask>  \r\n   </installation>\r\n</setup:Configuration>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(1, 1, 1, 20, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a, "cvc-elt.1.a: Cannot find the declaration of element 'setup:Configuration'."), XMLAssert.d(11, 67, 11, 67, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_4_2, "cvc-elt.4.2: Cannot resolve 'setup.p2:P2Task' to a type definition for element 'setupTask'."));
        ContentModelSettings settings = XMLAssert.getContentModelSettings(true, SchemaEnabled.onValidSchema);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
    }

    @Test
    public void noNamespaceSchemaLocationEnabledWithAlways() throws Exception {
        ContentModelSettings settings = XMLAssert.getContentModelSettings(true, SchemaEnabled.always);
        String xml = "<Annotation\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/pattern.xsd\"\r\n\tTerm=\"X\"></Annotation>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(3, 6, 3, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_pattern_valid), XMLAssert.d(3, 6, 3, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3));
        xml = "<Annotation\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"BAD_LOCATION.xsd\"\r\n\tTerm=\"X\"></Annotation>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(2, 31, 2, 49, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4), XMLAssert.d(0, 1, 0, 11, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a));
    }

    @Test
    public void noNamespaceSchemaLocationEnabledWithNever() throws Exception {
        ContentModelSettings settings = XMLAssert.getContentModelSettings(true, SchemaEnabled.never);
        String xml = "<Annotation\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/pattern.xsd\"\r\n\tTerm=\"X\"></Annotation>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
        xml = "<Annotation\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"BAD_LOCATION.xsd\"\r\n\tTerm=\"X\"></Annotation>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
    }

    @Test
    public void noNamespaceSchemaLocationEnabledWithOnValidSchema() throws Exception {
        ContentModelSettings settings = XMLAssert.getContentModelSettings(true, SchemaEnabled.onValidSchema);
        String xml = "<Annotation\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/pattern.xsd\"\r\n\tTerm=\"X\"></Annotation>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(3, 6, 3, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_pattern_valid), XMLAssert.d(3, 6, 3, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3));
        xml = "<Annotation\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"BAD_LOCATION.xsd\"\r\n\tTerm=\"X\"></Annotation>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
    }

    @Test
    public void schemaLocationEnabledWithAlways() throws Exception {
        ContentModelSettings settings = XMLAssert.getContentModelSettings(true, SchemaEnabled.always);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"team_namespace\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace src/test/resources/xsd/team.xsd \">\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(2, 10, 2, 29, (IXMLErrorCode)XMLSchemaErrorCode.cvc_maxlength_valid), XMLAssert.d(2, 10, 2, 29, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3), XMLAssert.d(1, 1, 1, 5, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_b));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"BAD_NAMESPACE\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace src/test/resources/xsd/team.xsd \">\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(1, 1, 1, 5, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"team_namespace\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace BAD_LOCATION.xsd \">\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(5, 40, 5, 56, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4), XMLAssert.d(1, 1, 1, 5, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a));
    }

    @Test
    public void schemaLocationEnabledWithNever() throws Exception {
        ContentModelSettings settings = XMLAssert.getContentModelSettings(true, SchemaEnabled.never);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"team_namespace\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace src/test/resources/xsd/team.xsd \">\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"BAD_NAMESPACE\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace src/test/resources/xsd/team.xsd \">\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"team_namespace\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace BAD_LOCATION.xsd \">\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
    }

    @Test
    public void schemaLocationEnabledWithOnValidSchema() throws Exception {
        ContentModelSettings settings = XMLAssert.getContentModelSettings(true, SchemaEnabled.onValidSchema);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"team_namespace\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace src/test/resources/xsd/team.xsd \">\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(2, 10, 2, 29, (IXMLErrorCode)XMLSchemaErrorCode.cvc_maxlength_valid), XMLAssert.d(2, 10, 2, 29, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3), XMLAssert.d(1, 1, 1, 5, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_b));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"BAD_NAMESPACE\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace src/test/resources/xsd/team.xsd \">\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<team\r\n     name=\"too long a string\"\r\n     xmlns=\"team_namespace\"\r\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n     xsi:schemaLocation=\"team_namespace BAD_LOCATION.xsd \">\r\n</team>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
    }

    @Test
    public void schemaLocationWithOddUris() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<ns:root\r\nxmlns:ns='http://foo'\r\nxmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\r\nxsi:schemaLocation='http://foo foo.xsd http://bar'>\r\n</ns:root>";
        Diagnostic d1 = XMLAssert.d(4, 19, 4, 50, (IXMLErrorCode)XMLSchemaErrorCode.SchemaLocation);
        Diagnostic d2 = XMLAssert.d(4, 31, 4, 38, (IXMLErrorCode)XMLSchemaErrorCode.schema_reference_4);
        Diagnostic d3 = XMLAssert.d(1, 1, 1, 8, (IXMLErrorCode)XMLSchemaErrorCode.cvc_elt_1_a);
        XMLAssert.testDiagnosticsFor(xml, d1, d2, d3);
    }

    private static void testDiagnosticsWithCatalogFor(String xml, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, "src/test/resources/catalogs/catalog.xml", expected);
    }

    private static void testDiagnosticsDisabledValidation(String xml) {
        ContentModelSettings settings = XMLAssert.getContentModelSettings(true, SchemaEnabled.never);
        XMLAssert.testDiagnosticsFor(xml, "src/test/resources/catalogs/catalog.xml", null, null, true, settings, new Diagnostic[0]);
    }

    private static String getGrammarFileURI(String grammarURI) throws URI.MalformedURIException {
        int index = grammarURI.lastIndexOf(46);
        String path = grammarURI.substring(index + 1, grammarURI.length());
        return XMLEntityManager.expandSystemId((String)grammarURI, (String)("src/test/resources/" + path + "/test.xml"), (boolean)true);
    }
}

