/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class EntityNotDeclaredCodeAction
implements ICodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(EntityNotDeclaredCodeAction.class.getName());

    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, SharedSettings sharedSettings, IComponentProvider componentProvider) {
        try {
            String entityName = EntityNotDeclaredCodeAction.getEntityName(diagnostic, document);
            if (entityName == null) {
                return;
            }
            DOMDocumentType docType = document.getDoctype();
            if (docType != null) {
                this.addEntityCodeAction(entityName, diagnostic, document, sharedSettings, codeActions);
            } else {
                this.addDoctypeAndEntityCodeAction(entityName, diagnostic, document, sharedSettings, codeActions);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In EntityNotDeclaredCodeAction the DOMDocument offset(s) is at a BadLocation", e);
        }
    }

    private void addEntityCodeAction(String entityName, Diagnostic diagnostic, DOMDocument document, SharedSettings settings, List<CodeAction> codeActions) throws BadLocationException {
        boolean hasInternalSubset;
        DOMDocumentType docType = document.getDoctype();
        Position docTypeEnd = document.positionAt(docType.getEnd());
        Position insertPosition = this.getEntityInsertPosition(document);
        String message = "Declare ENTITY " + entityName;
        String delimiter = document.lineDelimiter(insertPosition.getLine());
        XMLBuilder insertString = new XMLBuilder(settings, null, delimiter);
        boolean bl = hasInternalSubset = docType.getInternalSubset() != null;
        if (!hasInternalSubset) {
            String doctypeContent = docType.getTextContent();
            if (!Character.isWhitespace(doctypeContent.charAt(doctypeContent.length() - 2))) {
                insertString.startDoctypeInternalSubset();
            } else {
                insertString.startUnindentedDoctypeInternalSubset();
            }
            if (insertPosition.getLine() > 0) {
                insertString.linefeed();
            }
        } else if (insertPosition.getCharacter() != 0) {
            insertString.linefeed();
        }
        insertString.indent(1);
        EntityNotDeclaredCodeAction.addEntityDeclaration(entityName, insertString);
        if (docType.getInternalSubset() == null) {
            insertString.linefeed().endDoctypeInternalSubset();
        } else if (docTypeEnd.getLine() == insertPosition.getLine()) {
            insertString.linefeed();
        }
        CodeAction action = CodeActionFactory.insert(message, insertPosition, insertString.toString(), document.getTextDocument(), diagnostic);
        codeActions.add(action);
    }

    private void addDoctypeAndEntityCodeAction(String entityName, Diagnostic diagnostic, DOMDocument document, SharedSettings settings, List<CodeAction> codeActions) throws BadLocationException {
        Position insertPosition = this.getDoctypeInsertPosition(document);
        String delimiter = document.lineDelimiter(insertPosition.getLine());
        String message = "Declare DOCTYPE containing ENTITY " + entityName;
        DOMElement root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        XMLBuilder insertString = new XMLBuilder(settings, null, delimiter);
        if (insertPosition.getCharacter() > 0) {
            insertString.linefeed();
        }
        insertString.startDoctype().addParameter(root.getTagName()).startDoctypeInternalSubset().linefeed().indent(1);
        EntityNotDeclaredCodeAction.addEntityDeclaration(entityName, insertString);
        insertString.linefeed().endDoctypeInternalSubset().closeStartElement();
        Position rootStartPosition = document.positionAt(root.getStart());
        if (insertPosition.getLine() == rootStartPosition.getLine()) {
            insertString.linefeed();
        }
        CodeAction action = CodeActionFactory.insert(message, insertPosition, insertString.toString(), document.getTextDocument(), diagnostic);
        codeActions.add(action);
    }

    private Position getDoctypeInsertPosition(DOMDocument document) throws BadLocationException {
        if (!document.hasProlog()) {
            return new Position(0, 0);
        }
        int prologEnd = document.getChildren().get(0).getEnd();
        return document.positionAt(prologEnd);
    }

    private Position getEntityInsertPosition(DOMDocument document) throws BadLocationException {
        TextDocument textDocument = document.getTextDocument();
        DOMDocumentType docType = document.getDoctype();
        String subset = docType.getInternalSubset();
        if (subset == null) {
            return textDocument.positionAt(docType.getEnd() - 1);
        }
        DOMNode lastChild = docType.getLastChild();
        if (lastChild != null) {
            return textDocument.positionAt(lastChild.getEnd());
        }
        String subsetValue = "[" + subset + "]";
        int index = docType.getTextContent().indexOf(subsetValue);
        if (index >= 0) {
            return docType.getOwnerDocument().positionAt((index += subsetValue.length() - 1) + docType.getStart());
        }
        return null;
    }

    private static String getEntityName(Diagnostic diagnostic, DOMDocument doc) throws BadLocationException {
        Range range = diagnostic.getRange();
        String name = doc.getText().substring(doc.offsetAt(range.getStart()), doc.offsetAt(range.getEnd()));
        String removedAmpAndSemiColon = name.substring(1, name.length() - 1);
        if (!diagnostic.getMessage().contains("\"" + removedAmpAndSemiColon + "\"")) {
            return null;
        }
        return removedAmpAndSemiColon;
    }

    private static void addEntityDeclaration(String entityName, XMLBuilder builder) {
        builder.addDeclTagStart("ENTITY").addParameter(entityName).addParameter("\"entity-value\"").closeStartElement();
    }
}

