/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.type;

import java.util.Objects;
import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class LongValue
implements TypedValue<Long> {
    private final long value;

    public LongValue(long value) {
        this.value = value;
    }

    @Override
    public int compareTo(TypedValue<Long> otherTypedValue) {
        Objects.requireNonNull(otherTypedValue, "Typed Value cannot be null");
        return Long.valueOf(this.value).compareTo(otherTypedValue.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongValue other = (LongValue)obj;
        return this.value == other.value;
    }

    @Override
    public DataType getType() {
        return DataType.LONG;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public String toString() {
        return "LongValue [value=" + this.value + "]";
    }
}

