/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.signature;

import java.util.Objects;
import java.util.Optional;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ValidationResult {
    private boolean isSignatureValid = false;
    private Optional<String> imageDigest = Optional.empty();

    public ValidationResult() {
    }

    public ValidationResult(boolean signatureValid, String digest) {
        if (Objects.isNull(signatureValid) || Objects.isNull(digest)) {
            throw new NullPointerException("Signature results and digest cannot be null.");
        }
        if (signatureValid && digest.isEmpty()) {
            throw new IllegalArgumentException("Image digest must be provided when signature is valid.");
        }
        this.imageDigest = Optional.of(digest);
        this.isSignatureValid = signatureValid;
    }

    public boolean isSignatureValid() {
        return this.isSignatureValid;
    }

    public Optional<String> imageDigest() {
        return this.imageDigest;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationResult other = (ValidationResult)obj;
        return this.isSignatureValid == other.isSignatureValid && this.imageDigest.equals(other.imageDigest);
    }

    public int hashCode() {
        return Objects.hash(this.isSignatureValid, this.imageDigest);
    }
}

