/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.monitoradmin.job;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.knowhowlab.osgi.monitoradmin.LogVisitor;
import org.knowhowlab.osgi.monitoradmin.job.AbstractMonitoringJob;
import org.knowhowlab.osgi.monitoradmin.job.MonitoringJobVisitor;
import org.knowhowlab.osgi.monitoradmin.util.StatusVariablePath;
import org.osgi.service.monitor.StatusVariable;

public class ScheduledMonitoringJob
extends AbstractMonitoringJob
implements Runnable {
    private int measurementsTaken = 0;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    public ScheduledMonitoringJob(MonitoringJobVisitor visitor, LogVisitor logVisitor, String initiator, String[] statusVariablePaths, int schedule, int count) {
        super(visitor, logVisitor, initiator, statusVariablePaths, schedule, count);
        this.executorService.submit(this);
    }

    public void cancel() {
        this.isRunning = false;
        this.executorService.shutdownNow();
        this.logVisitor.info("Job Canceled: " + this, null);
    }

    public boolean isHandleUpdateEvent(String path) {
        return false;
    }

    public void handleUpdateEvent(String monitorableId, StatusVariable statusVariable) {
    }

    public void run() {
        while (this.isRunning()) {
            if (this.count == 0 || ++this.measurementsTaken < this.count) {
                try {
                    for (String path : this.statusVariablePaths) {
                        StatusVariablePath statusVariablePath = new StatusVariablePath(path);
                        StatusVariable statusVariable = this.visitor.getStatusVariable(statusVariablePath.getPath());
                        this.visitor.fireEvent(statusVariablePath.getMonitorableId(), statusVariable, this.getInitiator());
                    }
                    try {
                        TimeUnit.SECONDS.sleep(this.schedule);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.stop();
                    continue;
                }
            }
            this.stop();
        }
    }
}

