/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.system.dto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.kura.system.ExtendedProperties;
import org.eclipse.kura.system.ExtendedPropertyGroup;
import org.eclipse.kura.system.SystemService;

public class ExtendedPropertiesDTO {
    private String version;
    private Map<String, Map<String, String>> extendedProperties;

    public ExtendedPropertiesDTO(SystemService systemService) {
        Optional properties = systemService.getExtendedProperties();
        if (properties.isPresent()) {
            this.populateExtendedProperties((ExtendedProperties)properties.get(), s -> true);
        }
    }

    public ExtendedPropertiesDTO(SystemService systemService, List<String> groupNames) {
        Optional properties = systemService.getExtendedProperties();
        if (properties.isPresent()) {
            this.populateExtendedProperties((ExtendedProperties)properties.get(), groupNames::contains);
        }
    }

    private void populateExtendedProperties(ExtendedProperties properties, Predicate<String> condition) {
        this.version = properties.getVersion();
        this.extendedProperties = new HashMap<String, Map<String, String>>();
        for (ExtendedPropertyGroup group : properties.getPropertyGroups()) {
            this.putIf(group.getName(), group.getProperties(), condition.test(group.getName()));
        }
    }

    private void putIf(String key, Map<String, String> value, boolean condition) {
        if (condition) {
            this.extendedProperties.put(key, value);
        }
    }
}

