/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.asset.provider;

import java.util.Objects;
import org.eclipse.kura.asset.provider.BaseAsset;
import org.eclipse.kura.driver.Driver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DriverTrackerCustomizer
implements ServiceTrackerCustomizer<Driver, Driver> {
    private static final Logger logger = LoggerFactory.getLogger(DriverTrackerCustomizer.class);
    private final BaseAsset baseAsset;
    private final BundleContext context;
    private final String driverId;

    public DriverTrackerCustomizer(BundleContext context, BaseAsset baseAsset, String driverId) {
        Objects.requireNonNull(context, "Bundle context cannot be null");
        Objects.requireNonNull(baseAsset, "Asset cannot be null");
        Objects.requireNonNull(driverId, "Driver PID cannot be null");
        this.driverId = driverId;
        this.baseAsset = baseAsset;
        this.context = context;
    }

    public Driver addingService(ServiceReference<Driver> reference) {
        Driver driver = (Driver)this.context.getService(reference);
        if (reference.getProperty("kura.service.pid").equals(this.driverId)) {
            logger.info("Driver has been found by the driver tracker... ==> adding service");
            this.baseAsset.setDriver(driver);
        }
        return driver;
    }

    public void modifiedService(ServiceReference<Driver> reference, Driver service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void removedService(ServiceReference<Driver> reference, Driver service) {
        this.context.ungetService(reference);
        if (reference.getProperty("kura.service.pid").equals(this.driverId)) {
            logger.info("Driver has been removed by the driver tracker... {}", (Object)service);
            this.baseAsset.unsetDriver();
        }
    }
}

