/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.db.common;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.db.BaseDbService;
import org.eclipse.kura.internal.wire.db.common.CommonDbServiceProvider;
import org.eclipse.kura.internal.wire.db.common.DbServiceHelper;
import org.eclipse.kura.internal.wire.db.common.DbServiceProvider;
import org.eclipse.kura.wire.WireRecord;

public class BaseDbServiceProviderImpl
extends CommonDbServiceProvider
implements DbServiceProvider {
    private static final Logger logger = LogManager.getLogger(BaseDbServiceProviderImpl.class);
    private static final String SQL_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS {0} (ID BIGINT AUTO_INCREMENT, TIMESTAMP BIGINT, primary key (ID));";
    private static final String SQL_DELETE_RANGE_TABLE = "DELETE FROM {0} ORDER BY ID ASC LIMIT {1};";
    private static final String SQL_SET_AUTOINCREMENT = "ALTER TABLE {0} AUTO_INCREMENT = {1};";

    public BaseDbServiceProviderImpl(BaseDbService dbService) {
        this.dbHelper = DbServiceHelper.of(dbService);
    }

    @Override
    public void truncate(int noOfRecordsToKeep, String tableName, int maxTableSize) throws SQLException {
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        int tableSize = this.getTableSize(tableName);
        int entriesToDeleteCount = tableSize + 1;
        entriesToDeleteCount = maxTableSize < noOfRecordsToKeep ? (entriesToDeleteCount -= maxTableSize) : (entriesToDeleteCount -= noOfRecordsToKeep);
        String limit = Integer.toString(entriesToDeleteCount);
        Throwable throwable = null;
        Object var9_10 = null;
        try (Connection c = this.dbHelper.getConnection();){
            String catalog = c.getCatalog();
            DatabaseMetaData dbMetaData = c.getMetaData();
            Throwable throwable2 = null;
            Object var14_17 = null;
            try (ResultSet rsTbls = dbMetaData.getTables(catalog, null, tableName, TABLE_TYPE);){
                if (rsTbls.next()) {
                    if (noOfRecordsToKeep == 0) {
                        logger.info("Truncating table {}...", (Object)sqlTableName);
                        this.dbHelper.execute(c, this.format("TRUNCATE TABLE {0};", sqlTableName), new Integer[0]);
                        this.dbHelper.execute(c, this.format(SQL_SET_AUTOINCREMENT, sqlTableName, tableSize + 1), new Integer[0]);
                    } else {
                        logger.info("Partially emptying table {}", (Object)sqlTableName);
                        this.dbHelper.execute(c, this.format(SQL_DELETE_RANGE_TABLE, sqlTableName, limit), new Integer[0]);
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int getTableSize(String tableName) throws SQLException {
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection c = this.dbHelper.getConnection();){
            return this.getTableSize(sqlTableName, c, (string, objectArray) -> this.format((String)string, objectArray));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void reconcileTable(String tableName) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection c = this.dbHelper.getConnection();){
            this.reconcileTable(c, tableName, SQL_CREATE_TABLE, (string, objectArray) -> this.format((String)string, objectArray));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void reconcileColumns(String tableName, WireRecord wireRecord) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection c = this.dbHelper.getConnection();){
            this.reconcileColumns(c, tableName, wireRecord, (string, objectArray) -> this.format((String)string, objectArray));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void insertDataRecord(String tableName, WireRecord wireRecord) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection c = this.dbHelper.getConnection();){
            this.insertDataRecord(c, tableName, wireRecord, (string, objectArray) -> this.format((String)string, objectArray));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public List<WireRecord> performSQLQuery(String query) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection c = this.dbHelper.getConnection();){
            return this.performSQLQuery(c, query);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String format(String message, Object ... arguments) {
        return MessageFormat.format(message, arguments).replace("\"", "");
    }
}

