/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared;

import org.eclipse.kura.web.shared.GwtKuraErrorCode;

public class GwtKuraException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected GwtKuraErrorCode m_errorCode;
    protected String[] m_arguments;

    private GwtKuraException() {
    }

    public GwtKuraException(String message) {
        super(message);
    }

    private GwtKuraException(String message, Throwable cause) {
        super(message, cause);
    }

    private GwtKuraException(Throwable t) {
        super(t);
    }

    public GwtKuraException(GwtKuraErrorCode errorCode) {
        this.m_errorCode = errorCode;
    }

    public GwtKuraException(GwtKuraErrorCode errorCode, Throwable cause) {
        super(cause);
        this.m_errorCode = errorCode;
    }

    public GwtKuraException(GwtKuraErrorCode errorCode, Throwable cause, String ... arguments) {
        super(cause);
        this.m_errorCode = errorCode;
        this.m_arguments = arguments;
    }

    public static GwtKuraException internalError(Throwable cause, String message) {
        return new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, cause, message);
    }

    public static GwtKuraException internalError(String message) {
        return new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, null);
    }

    public GwtKuraErrorCode getCode() {
        return this.m_errorCode;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage();
    }

    @Override
    public String getLocalizedMessage() {
        if (GwtKuraErrorCode.INTERNAL_ERROR.equals((Object)this.m_errorCode) && this.m_arguments != null && this.m_arguments.length == 1) {
            return this.m_arguments[0];
        }
        String msg = this.m_errorCode.toString();
        return msg;
    }

    public String[] getArguments() {
        return this.m_arguments;
    }

    private String format(String s, Object[] arguments) {
        if (arguments == null) {
            return s;
        }
        int i = 0;
        while (i < arguments.length) {
            String delimiter = "{" + i + "}";
            while (s.contains(delimiter)) {
                s = s.replace(delimiter, String.valueOf(arguments[i]));
            }
            ++i;
        }
        return s;
    }
}

