/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.download.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraRuntimeException;
import org.eclipse.kura.core.deployment.DownloadStatus;
import org.eclipse.kura.core.deployment.download.DownloadCountingOutputStream;
import org.eclipse.kura.core.deployment.download.DownloadOptions;
import org.eclipse.kura.core.deployment.download.impl.GenericDownloadCountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDownloadCountingOutputStream
extends GenericDownloadCountingOutputStream
implements DownloadCountingOutputStream {
    private static final Logger s_logger = LoggerFactory.getLogger(HttpDownloadCountingOutputStream.class);
    private ExecutorService executor;
    private Future<Void> future;

    public HttpDownloadCountingOutputStream(DownloadOptions downloadOptions) {
        super(downloadOptions);
        this.setBufferSize(this.options.getBlockSize());
        this.setResolution(this.options.getNotifyBlockSize());
        this.setBlockDelay(this.options.getBlockDelay());
        this.setConnectTimeout(this.options.getTimeout());
    }

    @Override
    public void cancelDownload() throws Exception {
        if (this.executor != null && this.future != null) {
            this.future.cancel(true);
            this.executor.shutdownNow();
            this.postProgressEvent(this.options.getClientId(), this.getByteCount(), this.totalBytes, DownloadStatus.CANCELLED, "Download cancelled");
        }
    }

    @Override
    public void startWork() throws KuraException {
        this.executor = Executors.newSingleThreadExecutor();
        this.future = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean shouldAuthenticate = false;
                try {
                    try {
                        int newSize;
                        boolean bl = shouldAuthenticate = HttpDownloadCountingOutputStream.this.options.getUsername() != null && HttpDownloadCountingOutputStream.this.options.getPassword() != null && (!HttpDownloadCountingOutputStream.this.options.getUsername().trim().isEmpty() || HttpDownloadCountingOutputStream.this.options.getPassword().trim().isEmpty());
                        if (shouldAuthenticate) {
                            Authenticator.setDefault(new Authenticator(){

                                @Override
                                protected PasswordAuthentication getPasswordAuthentication() {
                                    return new PasswordAuthentication((this).HttpDownloadCountingOutputStream.this.options.getUsername(), (this).HttpDownloadCountingOutputStream.this.options.getPassword().toCharArray());
                                }
                            });
                        }
                        HttpURLConnection.setFollowRedirects(false);
                        URLConnection urlConnection = HttpDownloadCountingOutputStream.this.getUrlConnection(HttpDownloadCountingOutputStream.this.downloadURL);
                        HttpDownloadCountingOutputStream.this.testConnectionProtocol(urlConnection);
                        HttpDownloadCountingOutputStream.this.is = urlConnection.getInputStream();
                        String s = urlConnection.getHeaderField("Content-Length");
                        s_logger.info("Content-lenght: " + s);
                        HttpDownloadCountingOutputStream.this.setTotalBytes(s != null ? Integer.parseInt(s) : -1);
                        HttpDownloadCountingOutputStream.this.postProgressEvent(HttpDownloadCountingOutputStream.this.options.getClientId(), 0L, HttpDownloadCountingOutputStream.this.totalBytes, DownloadStatus.IN_PROGRESS, null);
                        int bufferSize = HttpDownloadCountingOutputStream.this.getBufferSize();
                        if (bufferSize == 0 && HttpDownloadCountingOutputStream.this.getTotalBytes() > 0L) {
                            bufferSize = newSize = Math.round((float)HttpDownloadCountingOutputStream.this.totalBytes / 100.0f + 1.0f);
                            HttpDownloadCountingOutputStream.this.setBufferSize(newSize);
                        } else if (bufferSize == 0) {
                            bufferSize = newSize = 4096;
                            HttpDownloadCountingOutputStream.this.setBufferSize(newSize);
                        }
                        long numBytes = IOUtils.copyLarge((InputStream)HttpDownloadCountingOutputStream.this.is, (OutputStream)((Object)HttpDownloadCountingOutputStream.this), (byte[])new byte[bufferSize]);
                        HttpDownloadCountingOutputStream.this.postProgressEvent(HttpDownloadCountingOutputStream.this.options.getClientId(), numBytes, HttpDownloadCountingOutputStream.this.totalBytes, DownloadStatus.COMPLETED, null);
                    }
                    catch (IOException e) {
                        HttpDownloadCountingOutputStream.this.postProgressEvent(HttpDownloadCountingOutputStream.this.options.getClientId(), HttpDownloadCountingOutputStream.this.getByteCount(), HttpDownloadCountingOutputStream.this.totalBytes, DownloadStatus.FAILED, e.getMessage());
                        throw new KuraConnectException((Object)e);
                    }
                }
                catch (Throwable throwable) {
                    if (HttpDownloadCountingOutputStream.this.is != null) {
                        try {
                            HttpDownloadCountingOutputStream.this.is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    try {
                        HttpDownloadCountingOutputStream.this.close();
                    }
                    catch (IOException iOException) {}
                    if (shouldAuthenticate) {
                        Authenticator.setDefault(null);
                    }
                    throw throwable;
                }
                if (HttpDownloadCountingOutputStream.this.is != null) {
                    try {
                        HttpDownloadCountingOutputStream.this.is.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    HttpDownloadCountingOutputStream.this.close();
                }
                catch (IOException iOException) {}
                if (shouldAuthenticate) {
                    Authenticator.setDefault(null);
                }
                return null;
            }
        });
        try {
            this.future.get();
        }
        catch (ExecutionException ex) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)ex, new Object[0]);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)ex, new Object[0]);
        }
    }

    private URLConnection getUrlConnection(String downloadUrlString) throws IOException {
        URL localUrl = new URL(downloadUrlString);
        URLConnection urlConnection = localUrl.openConnection();
        int connectTimeout = this.getConnectTimeout();
        int readTimeout = this.getPropReadTimeout();
        urlConnection.setConnectTimeout(connectTimeout);
        urlConnection.setReadTimeout(readTimeout);
        int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
        if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
            String newLocation = urlConnection.getHeaderField("Location");
            if (StringUtils.isNotEmpty((CharSequence)newLocation)) {
                return this.getUrlConnection(newLocation);
            }
            throw new KuraRuntimeException(KuraErrorCode.INVALID_PARAMETER);
        }
        return urlConnection;
    }

    private void testConnectionProtocol(URLConnection urlConnection) throws IOException, KuraConnectException {
        try {
            if (urlConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslManagerService.getSSLSocketFactory());
            } else if (!(urlConnection instanceof HttpURLConnection)) {
                this.postProgressEvent(this.options.getClientId(), this.getByteCount(), this.totalBytes, DownloadStatus.FAILED, "The request URL is not supported");
                throw new KuraConnectException((Object)"Unsupported protocol!");
            }
        }
        catch (GeneralSecurityException e) {
            this.postProgressEvent(this.options.getClientId(), this.getByteCount(), this.totalBytes, DownloadStatus.FAILED, e.getMessage());
            throw new KuraConnectException((Throwable)e, (Object)"Unsupported protocol!");
        }
    }
}

