/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.Date;
import org.eclipse.kura.KuraInvalidMessageException;
import org.eclipse.kura.KuraInvalidMetricTypeException;
import org.eclipse.kura.core.util.GZipUtil;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.message.protobuf.KuraPayloadProto;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPayloadProtoBufDecoderImpl {
    private static final Logger logger = LoggerFactory.getLogger(CloudPayloadProtoBufDecoderImpl.class);
    private byte[] bytes;

    public CloudPayloadProtoBufDecoderImpl(byte[] bytes) {
        this.bytes = bytes;
    }

    public KuraPayload buildFromByteArray() throws IOException {
        if (GZipUtil.isCompressed((byte[])this.bytes)) {
            try {
                this.bytes = GZipUtil.decompress((byte[])this.bytes);
            }
            catch (IOException iOException) {
                logger.info("Decompression failed");
            }
        }
        KuraPayloadProto.KuraPayload protoMsg = null;
        try {
            protoMsg = KuraPayloadProto.KuraPayload.parseFrom(this.bytes);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new KuraInvalidMessageException((Throwable)ipbe);
        }
        KuraPayload kuraMsg = new KuraPayload();
        if (protoMsg.hasTimestamp()) {
            kuraMsg.setTimestamp(new Date(protoMsg.getTimestamp()));
        }
        if (protoMsg.hasPosition()) {
            kuraMsg.setPosition(this.buildFromProtoBuf(protoMsg.getPosition()));
        }
        int i = 0;
        while (i < protoMsg.getMetricCount()) {
            String name = protoMsg.getMetric(i).getName();
            try {
                Object value = this.getProtoKuraMetricValue(protoMsg.getMetric(i), protoMsg.getMetric(i).getType());
                kuraMsg.addMetric(name, value);
            }
            catch (KuraInvalidMetricTypeException ihte) {
                logger.warn("During deserialization, ignoring metric named: {}. Unrecognized value type: {}", new Object[]{name, protoMsg.getMetric(i).getType(), ihte});
            }
            ++i;
        }
        if (protoMsg.hasBody()) {
            kuraMsg.setBody(protoMsg.getBody().toByteArray());
        }
        return kuraMsg;
    }

    private KuraPosition buildFromProtoBuf(KuraPayloadProto.KuraPayload.KuraPosition protoPosition) {
        KuraPosition position = new KuraPosition();
        if (protoPosition.hasLatitude()) {
            position.setLatitude(protoPosition.getLatitude());
        }
        if (protoPosition.hasLongitude()) {
            position.setLongitude(protoPosition.getLongitude());
        }
        if (protoPosition.hasAltitude()) {
            position.setAltitude(protoPosition.getAltitude());
        }
        if (protoPosition.hasPrecision()) {
            position.setPrecision(protoPosition.getPrecision());
        }
        if (protoPosition.hasHeading()) {
            position.setHeading(protoPosition.getHeading());
        }
        if (protoPosition.hasSpeed()) {
            position.setSpeed(protoPosition.getSpeed());
        }
        if (protoPosition.hasSatellites()) {
            position.setSatellites(protoPosition.getSatellites());
        }
        if (protoPosition.hasStatus()) {
            position.setStatus(protoPosition.getStatus());
        }
        if (protoPosition.hasTimestamp()) {
            position.setTimestamp(new Date(protoPosition.getTimestamp()));
        }
        return position;
    }

    private Object getProtoKuraMetricValue(KuraPayloadProto.KuraPayload.KuraMetric metric, KuraPayloadProto.KuraPayload.KuraMetric.ValueType type) throws KuraInvalidMetricTypeException {
        switch (type) {
            case DOUBLE: {
                return metric.getDoubleValue();
            }
            case FLOAT: {
                return Float.valueOf(metric.getFloatValue());
            }
            case INT64: {
                return metric.getLongValue();
            }
            case INT32: {
                return metric.getIntValue();
            }
            case BOOL: {
                return metric.getBoolValue();
            }
            case STRING: {
                return metric.getStringValue();
            }
            case BYTES: {
                ByteString bs = metric.getBytesValue();
                return bs.toByteArray();
            }
        }
        throw new KuraInvalidMetricTypeException((Object)type);
    }
}

