/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.log.LogService;

public class UpdateCommand
extends Command {
    public void execute(DeploymentSessionImpl session) throws DeploymentException {
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        AbstractDeploymentPackage targetPackage = session.getTargetAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        LogService log = session.getLog();
        HashMap<String, AbstractInfo> expectedBundles = new HashMap<String, AbstractInfo>();
        AbstractInfo[] bundleInfos = (AbstractInfo[])source.getBundleInfos();
        for (int i = 0; i < bundleInfos.length; ++i) {
            AbstractInfo bundleInfo = bundleInfos[i];
            if (bundleInfo.isMissing()) continue;
            expectedBundles.put(bundleInfo.getPath(), bundleInfo);
        }
        try {
            while (!expectedBundles.isEmpty()) {
                AbstractInfo entry = source.getNextEntry();
                if (entry == null) {
                    throw new DeploymentException(463, "Expected more bundles in the stream: " + expectedBundles.keySet());
                }
                String name = entry.getPath();
                BundleInfoImpl bundleInfo = (BundleInfoImpl)expectedBundles.remove(name);
                if (bundleInfo == null) {
                    throw new DeploymentException(463, "Resource '" + name + "' is not described in the manifest.");
                }
                Bundle bundle = targetPackage.getBundle(bundleInfo.getSymbolicName());
                try {
                    if (bundle == null) {
                        bundle = context.installBundle("osgi-dp:" + bundleInfo.getSymbolicName(), (InputStream)new BundleInputStream(source.getCurrentEntryStream()));
                        this.addRollback(new UninstallBundleRunnable(bundle, log));
                    } else {
                        Version targetVersion;
                        Version sourceVersion = bundleInfo.getVersion();
                        if (!sourceVersion.equals((Object)(targetVersion = Version.parseVersion((String)((String)bundle.getHeaders().get("Bundle-Version")))))) {
                            bundle.update((InputStream)new BundleInputStream(source.getCurrentEntryStream()));
                            this.addRollback(new UpdateBundleRunnable(bundle, targetPackage, log));
                        }
                    }
                }
                catch (BundleException be) {
                    if (this.isCancelled()) {
                        return;
                    }
                    throw new DeploymentException(463, "Could not install new bundle '" + name + "'", be);
                }
                if (!bundle.getSymbolicName().equals(bundleInfo.getSymbolicName())) {
                    throw new DeploymentException(457, "Installed/updated bundle symbolicname do not match what was installed/updated");
                }
                if (Version.parseVersion((String)((String)bundle.getHeaders().get("Bundle-Version"))).equals((Object)bundleInfo.getVersion())) continue;
                throw new DeploymentException(463, "Installed/updated bundle version do not match what was installed/updated");
            }
        }
        catch (IOException e) {
            throw new DeploymentException(463, "Problem while reading stream", e);
        }
    }

    private final class BundleInputStream
    extends InputStream {
        private final InputStream m_inputStream;

        private BundleInputStream(InputStream jarInputStream) {
            this.m_inputStream = jarInputStream;
        }

        public int read() throws IOException {
            this.checkCancel();
            return this.m_inputStream.read();
        }

        public int read(byte[] buffer) throws IOException {
            this.checkCancel();
            return this.m_inputStream.read(buffer);
        }

        public int read(byte[] buffer, int off, int len) throws IOException {
            this.checkCancel();
            return this.m_inputStream.read(buffer, off, len);
        }

        private void checkCancel() throws IOException {
            if (UpdateCommand.this.isCancelled()) {
                throw new IOException("Stream was cancelled");
            }
        }
    }

    private static class UpdateBundleRunnable
    implements Runnable {
        private final AbstractDeploymentPackage m_targetPackage;
        private final Bundle m_bundle;
        private final LogService m_log;

        public UpdateBundleRunnable(Bundle bundle, AbstractDeploymentPackage targetPackage, LogService log) {
            this.m_bundle = bundle;
            this.m_targetPackage = targetPackage;
            this.m_log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStream is = null;
            try {
                try {
                    is = this.m_targetPackage.getBundleStream(this.m_bundle.getSymbolicName());
                    if (is != null) {
                        this.m_bundle.update(is);
                    }
                    throw new Exception("Unable to get Inputstream for bundle " + this.m_bundle.getSymbolicName());
                }
                catch (Exception e) {
                    this.m_log.log(2, "Could not rollback update of bundle '" + this.m_bundle.getSymbolicName() + "'", (Throwable)e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    private static class UninstallBundleRunnable
    implements Runnable {
        private final Bundle m_bundle;
        private final LogService m_log;

        public UninstallBundleRunnable(Bundle bundle, LogService log) {
            this.m_bundle = bundle;
            this.m_log = log;
        }

        public void run() {
            try {
                this.m_bundle.uninstall();
            }
            catch (BundleException e) {
                this.m_log.log(2, "Could not rollback update of bundle '" + this.m_bundle.getSymbolicName() + "'", (Throwable)e);
            }
        }
    }
}

