/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.message.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.data.DataTransportToken;
import org.eclipse.kura.message.store.StoredMessage;
import org.eclipse.kura.message.store.provider.MessageStore;
import org.eclipse.kura.util.jdbc.ConnectionProvider;
import org.eclipse.kura.util.jdbc.JdbcUtil;
import org.eclipse.kura.util.jdbc.SQLFunction;
import org.eclipse.kura.util.message.store.JdbcMessageStoreQueries;

public abstract class AbstractJdbcMessageStoreImpl
implements MessageStore {
    private static final String TOPIC_ELEMENT = "topic";
    protected final String tableName;
    protected final String escapedTableName;
    protected final JdbcMessageStoreQueries queries;
    protected final ConnectionProvider connectionProvider;
    protected final Calendar utcCalendar;

    protected AbstractJdbcMessageStoreImpl(ConnectionProvider connectionProvider, String tableName) {
        if (tableName == null || tableName.trim().isEmpty()) {
            throw new IllegalArgumentException("Table name cannot be null or empty.");
        }
        this.tableName = tableName;
        this.connectionProvider = Objects.requireNonNull(connectionProvider, "Connection provider cannot be null");
        this.escapedTableName = this.escapeIdentifier(tableName);
        this.utcCalendar = this.buildUTCCalendar();
        this.queries = this.buildSqlMessageStoreQueries();
    }

    protected abstract JdbcMessageStoreQueries buildSqlMessageStoreQueries();

    protected String escapeIdentifier(String string) {
        String sanitizedName = string.replace("\"", "\"\"");
        return "\"" + sanitizedName + "\"";
    }

    protected void createTable() throws KuraStoreException {
        this.execute(this.queries.getSqlCreateTable(), new Object[0]);
    }

    protected void createIndexes() throws KuraStoreException {
        this.execute(this.queries.getSqlCreateNextMessageIndex(), new Object[0]);
        this.execute(this.queries.getSqlCreatePublishedOnIndex(), new Object[0]);
        this.execute(this.queries.getSqlCreateConfirmedOnIndex(), new Object[0]);
        this.execute(this.queries.getSqlCreateDroppedOnIndex(), new Object[0]);
    }

    public synchronized int getMessageCount() throws KuraStoreException {
        return (int)this.getMessageCountInternal();
    }

    protected long getMessageCountInternal() throws KuraStoreException {
        return this.connectionProvider.withPreparedStatement(this.queries.getSqlMessageCount(), (c, stmt) -> JdbcUtil.getFirstColumnValue(stmt::executeQuery, ResultSet::getLong), "Cannot get message count");
    }

    protected void validate(String topic) throws KuraStoreException {
        if (topic == null || topic.trim().length() == 0) {
            throw new KuraStoreException(null, (Object)"topic must be not null and not empty");
        }
    }

    protected long storeInternal(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraStoreException {
        this.validate(topic);
        Timestamp now = new Timestamp(new Date().getTime());
        return this.connectionProvider.withConnection(c -> {
            long result;
            Throwable throwable = null;
            Object var11_10 = null;
            try (PreparedStatement pstmt = c.prepareStatement(this.queries.getSqlStore(), new String[]{"id"});){
                pstmt.setString(1, topic);
                pstmt.setInt(2, qos);
                pstmt.setBoolean(3, retain);
                pstmt.setTimestamp(4, now, this.utcCalendar);
                pstmt.setTimestamp(5, null);
                pstmt.setInt(6, -1);
                pstmt.setTimestamp(7, null);
                pstmt.setBytes(8, payload);
                pstmt.setInt(9, priority);
                pstmt.setString(10, null);
                pstmt.setTimestamp(11, null);
                pstmt.execute();
                result = JdbcUtil.getFirstColumnValue(pstmt::getGeneratedKeys, ResultSet::getLong);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (this.isExplicitCommitEnabled()) {
                c.commit();
            }
            return result;
        }, "Cannot store message");
    }

    public Optional<StoredMessage> get(int msgId) throws KuraStoreException {
        return this.get(msgId, rs -> this.buildStoredMessageBuilder((ResultSet)rs, true).build());
    }

    protected Optional<StoredMessage> get(int msgId, SQLFunction<ResultSet, StoredMessage> messageBuilder) throws KuraStoreException {
        return this.connectionProvider.withPreparedStatement(this.queries.getSqlGetMessage(), (c, stmt) -> {
            stmt.setInt(1, msgId);
            return JdbcUtil.getFirstColumnValueOrEmpty(stmt::executeQuery, (rs, i) -> (StoredMessage)messageBuilder.call((ResultSet)rs));
        }, "Cannot get message by ID: " + msgId);
    }

    public Optional<StoredMessage> getNextMessage() throws KuraStoreException {
        return this.getNextMessage(rs -> this.buildStoredMessageBuilder((ResultSet)rs, true).build());
    }

    protected Optional<StoredMessage> getNextMessage(SQLFunction<ResultSet, StoredMessage> messageBuilder) throws KuraStoreException {
        return this.connectionProvider.withPreparedStatement(this.queries.getSqlGetNextMessage(), (c, stmt) -> JdbcUtil.getFirstColumnValueOrEmpty(stmt::executeQuery, (rs, i) -> (StoredMessage)messageBuilder.call((ResultSet)rs)), "Cannot get message next message");
    }

    public void markAsPublished(int msgId, DataTransportToken token) throws KuraStoreException {
        Timestamp now = new Timestamp(new Date().getTime());
        this.connectionProvider.withPreparedStatement(this.queries.getSqlSetPublishedQoS1(), (c, stmt) -> {
            stmt.setTimestamp(1, now, this.utcCalendar);
            stmt.setInt(2, token.getMessageId());
            stmt.setString(3, token.getSessionId());
            stmt.setInt(4, msgId);
            stmt.execute();
            if (this.isExplicitCommitEnabled()) {
                c.commit();
            }
            return null;
        }, "Cannot update timestamp");
    }

    public void markAsPublished(int msgId) throws KuraStoreException {
        this.updateTimestamp(this.queries.getSqlSetPublishedQoS0(), msgId);
    }

    public void markAsConfirmed(int msgId) throws KuraStoreException {
        this.updateTimestamp(this.queries.getSqlSetConfirmed(), msgId);
    }

    public List<StoredMessage> getUnpublishedMessages() throws KuraStoreException {
        return this.listMessages(this.queries.getSqlAllUnpublishedMessages(), new Integer[0]);
    }

    public List<StoredMessage> getInFlightMessages() throws KuraStoreException {
        return this.listMessages(this.queries.getSqlAllInFlightMessages(), new Integer[0]);
    }

    public synchronized List<StoredMessage> getDroppedMessages() throws KuraStoreException {
        return this.listMessages(this.queries.getSqlAllDroppedInFlightMessages(), new Integer[0]);
    }

    public synchronized void unpublishAllInFlighMessages() throws KuraStoreException {
        this.execute(this.queries.getSqlUnpublishAllInFlightMessages(), new Object[0]);
    }

    public synchronized void dropAllInFlightMessages() throws KuraStoreException {
        this.updateTimestamp(this.queries.getSqlDropAllInFlightMessages(), new Integer[0]);
    }

    public synchronized void deleteStaleMessages(int purgeAgeSeconds) throws KuraStoreException {
        long timestamp = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(purgeAgeSeconds);
        this.deleteStaleMessages(timestamp);
    }

    public void close() {
    }

    protected void deleteStaleMessages(Object timestamp) throws KuraStoreException {
        this.execute(this.queries.getSqlDeleteDroppedMessages(), timestamp);
        this.execute(this.queries.getSqlDeleteConfirmedMessages(), timestamp);
        this.execute(this.queries.getSqlDeletePublishedMessages(), timestamp);
    }

    protected void updateTimestamp(String sql, Integer ... msgIds) throws KuraStoreException {
        Timestamp now = new Timestamp(new Date().getTime());
        this.connectionProvider.withPreparedStatement(sql, (c, stmt) -> {
            stmt.setTimestamp(1, now, this.utcCalendar);
            int i = 0;
            while (i < msgIds.length) {
                stmt.setInt(2 + i, msgIds[i]);
                ++i;
            }
            stmt.execute();
            if (this.isExplicitCommitEnabled()) {
                c.commit();
            }
            return null;
        }, "Cannot update timestamp");
    }

    protected List<StoredMessage> listMessages(String sql, Integer ... params) throws KuraStoreException {
        return this.connectionProvider.withPreparedStatement(sql, (c, stmt) -> {
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    stmt.setInt(2 + i, params[i]);
                    ++i;
                }
            }
            Throwable throwable = null;
            Object var5_7 = null;
            try (ResultSet rs = stmt.executeQuery();){
                return this.buildStoredMessagesNoPayload(rs);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, "Cannot list messages");
    }

    protected void execute(String sql, Object ... params) throws KuraStoreException {
        this.connectionProvider.withPreparedStatement(sql, (c, stmt) -> {
            int i = 0;
            while (i < params.length) {
                stmt.setObject(1 + i, params[i]);
                ++i;
            }
            stmt.execute();
            if (this.isExplicitCommitEnabled()) {
                c.commit();
            }
            return null;
        }, "Cannot execute query");
    }

    protected List<StoredMessage> buildStoredMessagesNoPayload(ResultSet rs) throws SQLException {
        ArrayList<StoredMessage> messages = new ArrayList<StoredMessage>();
        while (rs.next()) {
            messages.add(this.buildStoredMessageBuilder(rs, false).build());
        }
        return messages;
    }

    protected StoredMessage.Builder buildStoredMessageBuilder(ResultSet rs, boolean includePayload) throws SQLException {
        String sessionId;
        StoredMessage.Builder builder = new StoredMessage.Builder(rs.getInt("id")).withTopic(rs.getString(TOPIC_ELEMENT)).withQos(rs.getInt("qos")).withRetain(rs.getBoolean("retain")).withCreatedOn((Date)rs.getTimestamp("createdOn", this.utcCalendar)).withPublishedOn((Date)rs.getTimestamp("publishedOn", this.utcCalendar)).withConfirmedOn((Date)rs.getTimestamp("confirmedOn", this.utcCalendar)).withPriority(rs.getInt("priority")).withDroppedOn((Date)rs.getTimestamp("droppedOn"));
        if (includePayload) {
            builder = builder.withPayload(rs.getBytes("payload"));
        }
        if ((sessionId = rs.getString("sessionId")) != null) {
            builder = builder.withDataTransportToken(new DataTransportToken(rs.getInt("publishedMessageId"), sessionId));
        }
        return builder;
    }

    protected Calendar buildUTCCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    protected boolean isExplicitCommitEnabled() {
        return false;
    }

    protected JdbcMessageStoreQueries getQueries() {
        return this.queries;
    }

    protected ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }
}

