/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.VersionRange;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.DeploymentException;

public class DeploymentPackageManifest {
    private final Manifest m_manifest;
    private final Version m_version;
    private final List m_bundleInfos = new ArrayList();
    private final List m_resourceInfos = new ArrayList();
    private final String m_symbolicName;
    private final VersionRange m_fixPackage;

    public DeploymentPackageManifest(Manifest manifest) throws DeploymentException {
        if (manifest == null || manifest.getMainAttributes() == null) {
            throw new DeploymentException(452);
        }
        this.m_manifest = manifest;
        Attributes mainAttributes = this.m_manifest.getMainAttributes();
        this.m_symbolicName = this.getNonNullHeader(mainAttributes.getValue("DeploymentPackage-SymbolicName"));
        String version = this.getNonNullHeader(mainAttributes.getValue("DeploymentPackage-Version"));
        try {
            this.m_version = new Version(version);
        }
        catch (IllegalArgumentException e) {
            throw new DeploymentException(452);
        }
        String fixPackage = mainAttributes.getValue("DeploymentPackage-FixPack");
        if (fixPackage != null) {
            try {
                this.m_fixPackage = VersionRange.parse(fixPackage);
            }
            catch (IllegalArgumentException iae) {
                throw new DeploymentException(452, "Invalid version range for header: DeploymentPackage-FixPack");
            }
        } else {
            this.m_fixPackage = null;
        }
        Map<String, Attributes> entries = this.m_manifest.getEntries();
        Iterator<String> i = entries.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            this.processEntry(key, entries.get(key), this.m_fixPackage != null);
        }
    }

    public String getHeader(String header) {
        return this.m_manifest.getMainAttributes().getValue(header);
    }

    public VersionRange getFixPackage() {
        return this.m_fixPackage;
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public List getBundleInfos() {
        return this.m_bundleInfos;
    }

    public List getResourceInfos() {
        return this.m_resourceInfos;
    }

    private void processEntry(String key, Attributes attributes, boolean isFixPack) throws DeploymentException {
        if (BundleInfoImpl.isBundleResource(attributes)) {
            BundleInfoImpl bundleInfo = new BundleInfoImpl(key, attributes);
            if (bundleInfo.isMissing() && !isFixPack) {
                throw new DeploymentException(452, "Header 'DeploymentPackage-Missing' for manifest entry '" + key + "' may only be 'true' if " + "DeploymentPackage-FixPack" + " manifest header is 'true'");
            }
            this.m_bundleInfos.add(bundleInfo);
        } else {
            this.m_resourceInfos.add(new ResourceInfoImpl(key, attributes));
        }
    }

    private String getNonNullHeader(String header) throws DeploymentException {
        if (header == null) {
            throw new DeploymentException(451);
        }
        if (header.trim().equals("")) {
            throw new DeploymentException(452);
        }
        return header;
    }
}

