/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.transport.socket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.transport.Transport;
import org.tigris.mtoolkit.iagent.transport.TransportConnection;
import org.tigris.mtoolkit.iagent.transport.TransportType;
import org.tigris.mtoolkit.iagent.transport.socket.SocketTransportConnection;
import org.tigris.mtoolkit.iagent.transport.socket.SocketTransportType;

public class SocketTransport
implements Transport {
    private String host;
    private SocketTransportType type;
    private List connections = new ArrayList();
    private volatile boolean closed;
    static /* synthetic */ Class class$0;

    public SocketTransport(SocketTransportType type, String host) {
        this.host = host;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportConnection createConnection(int port) throws IOException {
        if (this.closed) {
            throw new IOException("Transport is closed");
        }
        SocketTransportConnection connection = new SocketTransportConnection(this.host, port, 0);
        List list = this.connections;
        synchronized (list) {
            this.connections.add(connection);
        }
        return connection;
    }

    public String toString() {
        return "Socket Transport: " + this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SocketTransportConnection[] establishedConnections;
        this.closed = true;
        List list = this.connections;
        synchronized (list) {
            establishedConnections = this.connections.toArray(new SocketTransportConnection[this.connections.size()]);
        }
        int i = 0;
        while (i < establishedConnections.length) {
            try {
                establishedConnections[i].close();
            }
            catch (Throwable e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.tigris.mtoolkit.iagent.transport.socket.SocketTransport");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DebugUtils.error(clazz, "Failed to correctly close an connection: " + establishedConnections[i], e);
            }
            ++i;
        }
    }

    public String getId() {
        return this.host;
    }

    public TransportType getType() {
        return this.type;
    }

    public boolean isDisposed() {
        return this.closed;
    }
}

