/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.tigris.mtoolkit.iagent.Error;
import org.tigris.mtoolkit.iagent.event.EventData;
import org.tigris.mtoolkit.iagent.event.EventSynchronizer;
import org.tigris.mtoolkit.iagent.internal.rpc.Activator;
import org.tigris.mtoolkit.iagent.internal.rpc.DefaultBundleManagerDelegate;
import org.tigris.mtoolkit.iagent.internal.rpc.RemoteServiceAdminImpl;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.rpc.Remote;
import org.tigris.mtoolkit.iagent.rpc.RemoteBundleAdmin;
import org.tigris.mtoolkit.iagent.rpc.RemoteCapabilitiesManager;
import org.tigris.mtoolkit.iagent.rpc.spi.BundleManagerDelegate;

public class RemoteBundleAdminImpl
implements Remote,
RemoteBundleAdmin,
SynchronousBundleListener {
    public static final String SYNCH_BUNDLE_EVENTS = "synch_bundle_event";
    public static final String SYSTEM_BUNDLE_EVENT = "system_bundle_event";
    public static final String EVENT_TYPE_KEY = "type";
    public static final String EVENT_BUNDLE_ID_KEY = "bundle.id";
    private static final String PROP_SYSTEM_BUNDLES_LIST = "iagent.system.bundles.list";
    private static final String PROP_SYSTEM_BUNDLES = "iagent.system.bundles";
    private static final String SYSTEM_BUNDLES_FILE_NAME = "system_bundles.txt";
    private static final String SYSTEM_BUNDLES_RESOURCE_NAME = "/system_bundles.txt";
    private ServiceTracker packageAdminTrack;
    private ServiceTracker startLevelTrack;
    private ServiceTracker delegatesTrack;
    private ServiceRegistration registration;
    private BundleContext bc;
    private Set loadedSymbolicNames;
    private Bundle systemBundle;
    private BundleManagerDelegate defaultDelegate;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public Class[] remoteInterfaces() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteBundleAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    public void register(BundleContext bc) {
        this.debug("[register] Registering remote Bundle Admin...");
        this.bc = bc;
        this.defaultDelegate = new DefaultBundleManagerDelegate(bc);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.packageAdminTrack = new ServiceTracker(bc, clazz.getName(), null);
        this.packageAdminTrack.open();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.startLevelTrack = new ServiceTracker(bc, clazz2.getName(), null);
        this.startLevelTrack.open();
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.tigris.mtoolkit.iagent.rpc.spi.BundleManagerDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.delegatesTrack = new ServiceTracker(bc, clazz3.getName(), null);
        this.delegatesTrack.open();
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteBundleAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registration = bc.registerService(clazz4.getName(), (Object)this, null);
        bc.addBundleListener((BundleListener)this);
        RemoteCapabilitiesManager capMan = Activator.getCapabilitiesManager();
        if (capMan != null) {
            capMan.setCapability("remote.bundle.support", Boolean.TRUE);
        }
        this.debug("[register] Remote Bundle Admin Registered.");
    }

    public void unregister(BundleContext bc) {
        this.debug("[unregister] Unregistering remoteBundleAdmin...");
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (this.packageAdminTrack != null) {
            this.packageAdminTrack.close();
            this.packageAdminTrack = null;
        }
        if (this.startLevelTrack != null) {
            this.startLevelTrack.close();
            this.startLevelTrack = null;
        }
        bc.removeBundleListener((BundleListener)this);
        RemoteCapabilitiesManager capMan = Activator.getCapabilitiesManager();
        if (capMan != null) {
            capMan.setCapability("remote.bundle.support", new Boolean(false));
        }
        this.bc = null;
        this.debug("[unregister] Remote Bundle Admin unregistered.");
    }

    public int getBundleState(long id) {
        Bundle bundle = this.bc.getBundle(id);
        int bundleState = bundle != null ? bundle.getState() : 1;
        this.debug("[getBundleState] id " + id + "; state: " + bundleState);
        return bundleState;
    }

    public String getBundleLocation(long id) {
        Bundle bundle = this.bc.getBundle(id);
        if (bundle != null) {
            String bundleLocation = bundle.getLocation();
            this.debug("[getBundleLocation] id: " + id + "; location: " + bundleLocation);
            return bundleLocation;
        }
        this.info("[getBundleLocation] id: " + id + " -> No such bundle");
        return null;
    }

    public Dictionary getBundleHeaders(long id, String locale) {
        this.debug("[getBundleHeaders] >>> id: " + id + "; locale: " + locale);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            this.info("[getBundleHeaders] No such bundle");
            return null;
        }
        Dictionary headers = bundle.getHeaders(locale);
        Hashtable<String, String> converted = new Hashtable<String, String>();
        Enumeration e = headers.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ((Dictionary)converted).put(key.toString(), headers.get(key).toString());
        }
        this.debug("[getBundleHeaders] headers: " + DebugUtils.convertForDebug(converted));
        return converted;
    }

    public Object getBundleHeader(long id, String headerName, String locale) {
        this.debug("[getBundleHeader] >>> id: " + id + "; headerName" + headerName + "; locale" + locale);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            Error error = new Error(-10000, "Bundle " + id + " has been uninstalled");
            this.info("[getBundleHeader] No such bundle: " + error);
            return error;
        }
        Dictionary headers = bundle.getHeaders(locale);
        Object value = headers.get(headerName);
        String bundleHeader = value != null ? value.toString() : null;
        this.debug("[getBundleHeader] header value: " + bundleHeader);
        return bundleHeader;
    }

    public long getBundleLastModified(long id) {
        this.debug("[getBundleLastModified] >>> id: " + id);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            this.info("[getBundleLastModified] No such bundle");
            return -2L;
        }
        long bundleLastModified = bundle.getLastModified();
        this.debug("[getBundleLastModified] last modified: " + bundleLastModified);
        return bundleLastModified;
    }

    public String getBundleSymbolicName(long id) {
        this.debug("[getBundleSymbolicName] >>> id: " + id);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            this.info("[getBundleSymbolicName] No such bundle");
            return null;
        }
        String symbolicName = bundle.getSymbolicName();
        symbolicName = symbolicName != null ? symbolicName : "";
        this.debug("[getBundleSymbolicName] symbolic name: " + symbolicName);
        return symbolicName;
    }

    public Object startBundle(long id, int flags) {
        this.debug("[startBundle] >>> id: " + id + "; flags" + flags);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            Error error = new Error(-10000, "Bundle " + id + " has been uninstalled");
            this.info("[startBundle] No such bundle");
            return error;
        }
        try {
            try {
                bundle.start(flags);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                bundle.start();
            }
        }
        catch (BundleException e) {
            Error error = new Error(-6000, "Failed to start bundle: " + e.getMessage());
            this.info("[startBundle] Bundle cannot be started: " + error, e);
            return error;
        }
        catch (IllegalStateException illegalStateException) {
            Error error = new Error(-10000, "Bundle " + id + " has been uninstalled");
            this.info("[startBundle] No such bundle: " + error);
            return error;
        }
        catch (Throwable t) {
            Error error = new Error(-6000, "Failed to start bundle: " + (t.getMessage() != null ? t.getMessage() : t.toString()));
            this.info("[startBundle] Bundle cannot be started: " + error, t);
            return error;
        }
        this.debug("[startBundle] Bundle started successfully");
        return null;
    }

    public Object stopBundle(long id, int flags) {
        this.debug("[stopBundle] id: " + id + "; flags" + flags);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            Error error = new Error(-10000, "Bundle " + id + " has been uninstalled");
            this.debug("[stopBundle] No such bundle: " + error);
            return error;
        }
        try {
            try {
                bundle.stop(flags);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                bundle.stop();
            }
        }
        catch (BundleException e) {
            Error error = new Error(-6000, "Failed to stop bundle: " + e.getMessage());
            this.info("[stopBundle] Unable to stop bundle: " + error, e);
            return error;
        }
        catch (IllegalStateException illegalStateException) {
            Error error = new Error(-10000, null);
            this.info("[stopBundle] No such bundle: " + error);
            return error;
        }
        catch (Throwable t) {
            Error error = new Error(-6000, "Failed to stop bundle: " + (t.getMessage() != null ? t.getMessage() : t.toString()));
            this.info("[stopBundle] Unable to stop bundle: " + error, t);
            return error;
        }
        this.debug("[stopBundle] Successfully stopped");
        return null;
    }

    public boolean resolveBundles(long[] ids) {
        PackageAdmin packageAdmin;
        if (ids == null) {
            this.info("[resolveBundles] Passed bundle ids must not be null");
            throw new IllegalArgumentException("Passed bundle ids must be not null");
        }
        this.debug("[resolveBundles] bundles: " + DebugUtils.convertForDebug(ids));
        Vector<Bundle> v = new Vector<Bundle>();
        int i = 0;
        while (i < ids.length) {
            Bundle b = this.bc.getBundle(ids[i]);
            if (b != null) {
                v.addElement(b);
            }
            ++i;
        }
        Object[] bs = null;
        if (v.size() > 0) {
            bs = new Bundle[v.size()];
            v.copyInto(bs);
        }
        if ((packageAdmin = (PackageAdmin)this.packageAdminTrack.getService()) == null) {
            this.info("[resolveBundles] PackageAdmin service is not available!");
            throw new IllegalStateException("PackageAdmin is not available at the moment");
        }
        boolean areBundlesResolved = packageAdmin.resolveBundles((Bundle[])bs);
        this.debug("[resolveBundles] Bundles resolved successfully: " + areBundlesResolved);
        return areBundlesResolved;
    }

    public long[] listBundles() {
        this.debug("[listBundles] >>>");
        Bundle[] bundles = this.bc.getBundles();
        long[] bids = RemoteBundleAdminImpl.convertBundlesToIds(bundles);
        this.debug("[listBundles] bundles: " + DebugUtils.convertForDebug(bids));
        return bids;
    }

    public Object getBundlesSnapshot(int includeOptions, Dictionary properties) {
        this.debug("[getBundlesSnapshot] >>>");
        long[] ids = this.listBundles();
        ArrayList snapshots = new ArrayList();
        int i = 0;
        while (i < ids.length) {
            block8: {
                Hashtable<String, Object> bundleInfo;
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                bundleInfo = new Hashtable<String, Object>();
                                ((Dictionary)bundleInfo).put(EVENT_BUNDLE_ID_KEY, new Long(ids[i]));
                                if ((includeOptions & 1) == 0) break block7;
                                Dictionary headers = this.getBundleHeaders(ids[i], null);
                                if (headers == null) break block8;
                                ((Dictionary)bundleInfo).put("bundle.headers", headers);
                            }
                            if ((includeOptions & 2) == 0) break block9;
                            int state = this.getBundleState(ids[i]);
                            if (state == 1) break block8;
                            ((Dictionary)bundleInfo).put("bundle.state", new Integer(state));
                        }
                        if ((includeOptions & 4) == 0) break block10;
                        Dictionary[] registeredServices = this.getRegisteredServices(ids[i]);
                        if (registeredServices == null) break block8;
                        ((Dictionary)bundleInfo).put("registered.services", registeredServices);
                    }
                    if ((includeOptions & 8) == 0) break block11;
                    Dictionary[] usedServices = this.getUsingServices(ids[i]);
                    if (usedServices == null) break block8;
                    ((Dictionary)bundleInfo).put("used.services", usedServices);
                }
                snapshots.add(bundleInfo);
            }
            ++i;
        }
        Dictionary[] result = snapshots.toArray(new Dictionary[snapshots.size()]);
        String transportType = System.getProperty("iagent.snapshot.transport.type");
        if ("compressed".equals(transportType)) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(new DeflaterOutputStream(bos));
                oos.writeObject(result);
                oos.close();
                return bos.toByteArray();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public Object installBundle(String location, InputStream is) {
        this.debug("[installBundle] location: " + location + "; inputStream: " + is);
        Object result = this.getDelegate().installBundle(location, is);
        if (result instanceof Error) {
            this.info("[installBundle] Unable to install bundle: " + result);
            return result;
        }
        Bundle bundle = (Bundle)result;
        Long bundleId = new Long(bundle.getBundleId());
        this.debug("[installBundle] Bundle installed successfully. Id: " + bundleId);
        return bundleId;
    }

    private BundleManagerDelegate getDelegate() {
        BundleManagerDelegate delegate = (BundleManagerDelegate)this.delegatesTrack.getService();
        if (delegate != null) {
            return delegate;
        }
        return this.defaultDelegate;
    }

    public Object uninstallBundle(long id) {
        this.debug("[uninstallBundle] id: " + id);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle != null) {
            Object result = this.getDelegate().uninstallBundle(bundle);
            if (result instanceof Error) {
                this.info("[uninstallBundle] Unable to uninstall bundle: " + result);
                return result;
            }
            this.debug("[uninstallBundle] Bundle uninstalled");
            return result;
        }
        Error error = new Error(-10000, "Bundle " + id + " has been uninstalled");
        this.info("[uninstallBundle] Unable to uninstall bundle: " + error);
        return error;
    }

    public long[] getBundles(String symbolicName, String version) {
        this.debug("[getBundles] symbolicName: " + symbolicName + "; version: " + version);
        PackageAdmin admin = (PackageAdmin)this.packageAdminTrack.getService();
        if (admin == null) {
            throw new IllegalStateException("No PackageAdmin available");
        }
        Bundle[] bundles = admin.getBundles(symbolicName, version);
        long[] bids = RemoteBundleAdminImpl.convertBundlesToIds(bundles);
        this.debug("[getBundles] Bundles successfully gotten: " + DebugUtils.convertForDebug(bids));
        return bids;
    }

    public Object updateBundle(long id, InputStream is) {
        this.debug("[updateBundle] installBundle; id: " + id + "; inputStream: " + is);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            Error error = new Error(-10000, "Bundle " + id + " has been uninstalled");
            this.info("[updateBundle] No such bundle: " + error);
            return error;
        }
        Object result = this.getDelegate().updateBundle(bundle, is);
        if (result instanceof Error) {
            this.info("[updateBundle] Unable to update bundle: " + result);
        } else {
            this.debug("[updateBundle] Bundle updated successfully");
        }
        return result;
    }

    public Dictionary[] getRegisteredServices(long id) {
        this.debug("[getRegisteredServices] id: " + id);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            this.info("[getRegisteredServices] No such bundle");
            return null;
        }
        try {
            ServiceReference[] refs = bundle.getRegisteredServices();
            return RemoteServiceAdminImpl.convertReferences(refs);
        }
        catch (IllegalStateException illegalStateException) {
            this.info("[getRegisteredServices] No such bundle");
            return null;
        }
    }

    public Dictionary[] getUsingServices(long id) {
        this.debug("[getUsingServices] id: " + id);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            this.info("[getUsingServices] No such bundle");
            return null;
        }
        try {
            ServiceReference[] refs = bundle.getServicesInUse();
            Object[] convertedReferences = RemoteServiceAdminImpl.convertReferences(refs);
            this.debug("[getUsingServices] Used services: " + DebugUtils.convertForDebug(convertedReferences));
            return convertedReferences;
        }
        catch (IllegalStateException illegalStateException) {
            this.info("[getUsingServices] No such bundle");
            return null;
        }
    }

    public long[] getFragmentBundles(long id) {
        this.debug("[getFragmentBundles] id: " + id);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            this.info("[getFragmentBundles] No such bundle");
            return null;
        }
        PackageAdmin admin = (PackageAdmin)this.packageAdminTrack.getService();
        if (admin == null) {
            this.info("[getFragmentBundles] No packageAdmin");
            return new long[0];
        }
        Bundle[] fragmentBundles = admin.getFragments(bundle);
        long[] bids = RemoteBundleAdminImpl.convertBundlesToIds(fragmentBundles);
        this.debug("[getFragmentBundles] Fragment bundles successfully gotten: " + DebugUtils.convertForDebug(bids));
        return bids;
    }

    public long[] getHostBundles(long id) {
        this.debug("[getHostBundles] id: " + id);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            this.info("[getHostBundles] No such bundle");
            return null;
        }
        PackageAdmin admin = (PackageAdmin)this.packageAdminTrack.getService();
        if (admin == null) {
            this.info("[getHostBundles] No packageAdmin");
            return new long[0];
        }
        Bundle[] hostBundles = admin.getHosts(bundle);
        long[] bids = RemoteBundleAdminImpl.convertBundlesToIds(hostBundles);
        this.debug("[getHostBundles] Host bundles successfully gotten: " + DebugUtils.convertForDebug(bids));
        return bids;
    }

    public int getBundleType(long id) {
        this.debug("[getBundleType] id: " + id);
        Bundle bundle = this.bc.getBundle(id);
        if (bundle == null) {
            this.info("[getBundleType] No such bundle");
            return -1;
        }
        PackageAdmin admin = (PackageAdmin)this.packageAdminTrack.getService();
        if (admin == null) {
            this.info("[getBundleType] No packageAdmin");
            return -2;
        }
        int bundleType = admin.getBundleType(bundle);
        this.debug("[getBundleType] Bundle Type successfully gotten: " + bundleType);
        return bundleType;
    }

    static long[] convertBundlesToIds(Bundle[] bundles) {
        if (bundles == null) {
            return new long[0];
        }
        long[] bids = new long[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            bids[i] = bundles[i].getBundleId();
            ++i;
        }
        return bids;
    }

    public void bundleChanged(BundleEvent event) {
        if (this.systemBundle == null) {
            this.systemBundle = this.bc.getBundle(0L);
        }
        if (this.systemBundle.getState() == 16) {
            return;
        }
        if (this.bc.getBundle().getState() == 16) {
            return;
        }
        this.debug("[bundleChanged] Event type is BundleEvent." + event.getType());
        EventSynchronizer synchronizer = Activator.getSynchronizer();
        if (synchronizer != null) {
            Dictionary convEvent = this.convertBundleEvent(event);
            this.debug("[bundleChanged] Sending event through existing pmpConnection. eventType: " + event.getType());
            String symbolicName = event.getBundle().getSymbolicName();
            if (event.getType() == 1 && symbolicName != null && this.isBundleSystem(symbolicName)) {
                synchronizer.enqueue(new EventData(new Long(event.getBundle().getBundleId()), SYSTEM_BUNDLE_EVENT));
            }
            synchronizer.enqueue(new EventData(convEvent, SYNCH_BUNDLE_EVENTS));
            this.debug("[bundleChanged] Bundle successfully changed");
        } else {
            this.info("[bundleChanged] Event synchronizer was disabled.");
        }
    }

    private boolean isBundleSystem(String symbolicName) {
        if (this.loadedSymbolicNames != null) {
            return this.loadedSymbolicNames.contains(symbolicName);
        }
        return false;
    }

    private Dictionary convertBundleEvent(BundleEvent bEvent) {
        Hashtable<String, Number> event = new Hashtable<String, Number>();
        ((Dictionary)event).put(EVENT_TYPE_KEY, new Integer(bEvent.getType()));
        ((Dictionary)event).put(EVENT_BUNDLE_ID_KEY, new Long(bEvent.getBundle().getBundleId()));
        return event;
    }

    private final void debug(String message) {
        DebugUtils.debug(this, message);
    }

    private final void info(String message) {
        DebugUtils.info(this, message);
    }

    private final void info(String message, Throwable t) {
        DebugUtils.info(this, message, t);
    }

    private final void error(String message, Throwable e) {
        DebugUtils.error(this, message, e);
    }

    public long getRemoteServiceID() {
        ServiceReference localRef;
        block5: {
            ServiceRegistration localRegistration;
            block4: {
                try {
                    localRegistration = this.registration;
                    if (localRegistration != null) break block4;
                    return -1L;
                }
                catch (IllegalStateException illegalStateException) {
                    return -1L;
                }
            }
            localRef = localRegistration.getReference();
            if (localRef != null) break block5;
            return -1L;
        }
        return (Long)localRef.getProperty("service.id");
    }

    public long getBundleByLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("getBundleByLocation requires non-null string passed as arg");
        }
        Bundle[] bundles = this.bc.getBundles();
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            if (location.equals(bundle.getLocation())) {
                return bundle.getBundleId();
            }
            ++i;
        }
        return -1L;
    }

    public String[] getAgentData() {
        Bundle agentBundle = this.bc.getBundle();
        String agentVersion = (String)agentBundle.getHeaders().get("Bundle-Version");
        String[] agentData = new String[]{Long.toString(agentBundle.getBundleId()), agentVersion};
        return agentData;
    }

    public String[] getSystemBundlesNames() {
        Set symbolicNames = this.getSystemSymbolicNames();
        ArrayList<String> systemBundlesNames = new ArrayList<String>(symbolicNames.size());
        Bundle[] allBundles = this.bc.getBundles();
        int i = 0;
        while (i < allBundles.length) {
            Iterator iter = symbolicNames.iterator();
            while (iter.hasNext()) {
                String symbolicName = (String)iter.next();
                if (!symbolicName.equals(allBundles[i].getSymbolicName())) continue;
                systemBundlesNames.add(symbolicName);
            }
            ++i;
        }
        return systemBundlesNames.toArray(new String[systemBundlesNames.size()]);
    }

    public long[] getSystemBundlesIDs() {
        Set symbolicNames = this.getSystemSymbolicNames();
        LinkedList<Bundle> systemBundles = new LinkedList<Bundle>();
        Bundle[] allBundles = this.bc.getBundles();
        int i = 0;
        while (i < allBundles.length) {
            Iterator iter = symbolicNames.iterator();
            while (iter.hasNext()) {
                String symbolicName = (String)iter.next();
                if (!symbolicName.equals(allBundles[i].getSymbolicName())) continue;
                systemBundles.add(allBundles[i]);
            }
            ++i;
        }
        return RemoteBundleAdminImpl.convertBundlesToIds(systemBundles.toArray(new Bundle[systemBundles.size()]));
    }

    /*
     * Exception decompiling
     */
    private Set getSystemSymbolicNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [7 : 330->333)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getBundleStartLevel(long id) {
        Bundle bundle = this.bc.getBundle(id);
        StartLevel slService = (StartLevel)this.startLevelTrack.getService();
        if (slService != null) {
            return slService.getBundleStartLevel(bundle);
        }
        return -1;
    }

    public int getFrameworkStartLevel() {
        StartLevel slService = (StartLevel)this.startLevelTrack.getService();
        if (slService != null) {
            return slService.getStartLevel();
        }
        return -1;
    }

    public String getSystemProperty(String name) {
        return System.getProperty(name);
    }
}

