/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.kura.core.net.AbstractNetInterface;
import org.eclipse.kura.core.net.NetInterfaceAddressImpl;
import org.eclipse.kura.net.LoopbackInterface;
import org.eclipse.kura.net.NetInterface;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopbackInterfaceImpl<T extends NetInterfaceAddress>
extends AbstractNetInterface<T>
implements LoopbackInterface<T> {
    private static final Logger s_logger = LoggerFactory.getLogger(LoopbackInterfaceImpl.class);

    public LoopbackInterfaceImpl(String name) {
        super(name);
    }

    public LoopbackInterfaceImpl(LoopbackInterface<? extends NetInterfaceAddress> other) {
        super((NetInterface<? extends NetInterfaceAddress>)other);
        List otherNetInterfaceAddresses = other.getNetInterfaceAddresses();
        ArrayList<NetInterfaceAddressImpl> interfaceAddresses = new ArrayList<NetInterfaceAddressImpl>();
        if (otherNetInterfaceAddresses != null) {
            for (NetInterfaceAddress netInterfaceAddress : otherNetInterfaceAddresses) {
                try {
                    NetInterfaceAddressImpl copiedInterfaceAddressImpl = new NetInterfaceAddressImpl(netInterfaceAddress);
                    interfaceAddresses.add(copiedInterfaceAddressImpl);
                }
                catch (Exception exception) {
                    s_logger.debug("Could not copy interface address: " + netInterfaceAddress);
                }
            }
        }
        this.setNetInterfaceAddresses(interfaceAddresses);
    }

    public NetInterfaceType getType() {
        return NetInterfaceType.LOOPBACK;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

