/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.kura.core.net.AbstractNetInterface;
import org.eclipse.kura.core.net.NetInterfaceAddressImpl;
import org.eclipse.kura.net.EthernetInterface;
import org.eclipse.kura.net.NetInterface;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetInterfaceImpl<T extends NetInterfaceAddress>
extends AbstractNetInterface<T>
implements EthernetInterface<T> {
    private static final Logger s_logger = LoggerFactory.getLogger(EthernetInterfaceImpl.class);
    private boolean linkUp;

    public EthernetInterfaceImpl(String name) {
        super(name);
    }

    public EthernetInterfaceImpl(EthernetInterface<? extends NetInterfaceAddress> other) {
        super((NetInterface<? extends NetInterfaceAddress>)other);
        this.linkUp = other.isLinkUp();
        List otherNetInterfaceAddresses = other.getNetInterfaceAddresses();
        ArrayList<NetInterfaceAddressImpl> interfaceAddresses = new ArrayList<NetInterfaceAddressImpl>();
        if (otherNetInterfaceAddresses != null) {
            for (NetInterfaceAddress netInterfaceAddress : otherNetInterfaceAddresses) {
                try {
                    NetInterfaceAddressImpl copiedInterfaceAddressImpl = new NetInterfaceAddressImpl(netInterfaceAddress);
                    interfaceAddresses.add(copiedInterfaceAddressImpl);
                }
                catch (Exception exception) {
                    s_logger.debug("Could not copy interface address: " + netInterfaceAddress);
                }
            }
        }
        this.setNetInterfaceAddresses(interfaceAddresses);
    }

    public NetInterfaceType getType() {
        return NetInterfaceType.ETHERNET;
    }

    public boolean isLinkUp() {
        return this.linkUp;
    }

    public void setLinkUp(boolean linkUp) {
        this.linkUp = linkUp;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(" :: linkUp=").append(this.linkUp);
        return sb.toString();
    }
}

