/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.net.NetInterface;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceState;
import org.eclipse.kura.usb.UsbDevice;

public abstract class AbstractNetInterface<T extends NetInterfaceAddress>
implements NetInterface<T> {
    private String name;
    private byte[] hardwareAddress;
    private boolean loopback;
    private boolean pointToPoint;
    private boolean virtual;
    private boolean supportsMulticast;
    private boolean up;
    private int mtu;
    private UsbDevice usbDevice;
    private String driver;
    private String driverVersion;
    private String firmwareVersion;
    private NetInterfaceState state;
    private boolean autoConnect;
    private List<T> interfaceAddresses;

    protected AbstractNetInterface(String name) {
        this.name = name;
        this.interfaceAddresses = new ArrayList<T>();
    }

    protected AbstractNetInterface(NetInterface<? extends NetInterfaceAddress> other) {
        this.name = other.getName();
        this.hardwareAddress = other.getHardwareAddress();
        this.loopback = other.isLoopback();
        this.pointToPoint = other.isPointToPoint();
        this.virtual = other.isVirtual();
        this.supportsMulticast = other.supportsMulticast();
        this.up = other.isUp();
        this.mtu = other.getMTU();
        this.usbDevice = other.getUsbDevice();
        this.driver = other.getDriver();
        this.driverVersion = other.getDriverVersion();
        this.firmwareVersion = other.getFirmwareVersion();
        this.state = other.getState();
        this.autoConnect = other.isAutoConnect();
        this.interfaceAddresses = new ArrayList<T>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getHardwareAddress() {
        return this.hardwareAddress;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public boolean isPointToPoint() {
        return this.pointToPoint;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean supportsMulticast() {
        return this.supportsMulticast;
    }

    public boolean isUp() {
        return this.up;
    }

    public int getMTU() {
        return this.mtu;
    }

    public void setMTU(int mtu) {
        this.mtu = mtu;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public NetInterfaceState getState() {
        return this.state;
    }

    public void setState(NetInterfaceState state) {
        this.state = state;
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    public void setHardwareAddress(byte[] hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
    }

    public void setLoopback(boolean loopback) {
        this.loopback = loopback;
    }

    public void setPointToPoint(boolean pointToPoint) {
        this.pointToPoint = pointToPoint;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public void setSupportsMulticast(boolean supportsMulticast) {
        this.supportsMulticast = supportsMulticast;
    }

    public void setUp(boolean up) {
        this.up = up;
    }

    public void setUsbDevice(UsbDevice usbDevice) {
        this.usbDevice = usbDevice;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    public List<T> getNetInterfaceAddresses() {
        if (this.interfaceAddresses != null) {
            return Collections.unmodifiableList(this.interfaceAddresses);
        }
        return null;
    }

    public void setNetInterfaceAddresses(List<T> interfaceAddresses) {
        this.interfaceAddresses = interfaceAddresses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this.name);
        if (this.hardwareAddress != null && this.hardwareAddress.length == 6) {
            sb.append(" :: hardwareAddress=").append(NetworkUtil.macToString(this.hardwareAddress));
        }
        sb.append(" :: loopback=").append(this.loopback).append(" :: pointToPoint=").append(this.pointToPoint).append(" :: virtual=").append(this.virtual).append(" :: supportsMulticast=").append(this.supportsMulticast).append(" :: up=").append(this.up).append(" :: mtu=").append(this.mtu);
        if (this.usbDevice != null) {
            sb.append(" :: usbDevice=").append(this.usbDevice);
        }
        sb.append(" :: driver=").append(this.driver).append(" :: driverVersion=").append(this.driverVersion).append(" :: firmwareVersion=").append(this.firmwareVersion).append(" :: state=").append(this.state).append(" :: autoConnect=").append(this.autoConnect);
        if (this.interfaceAddresses != null && this.interfaceAddresses.size() > 0) {
            sb.append(" :: InterfaceAddress=");
            for (NetInterfaceAddress interfaceAddress : this.interfaceAddresses) {
                sb.append(interfaceAddress).append(" ");
            }
        }
        return sb.toString();
    }
}

