/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.eclipse.kura.db.DbService;
import org.eclipse.kura.system.SystemService;
import org.hsqldb.jdbc.JDBCPool;
import org.hsqldb.jdbcDriver;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsqlDbServiceImpl
implements DbService {
    private static Logger s_logger = LoggerFactory.getLogger(HsqlDbServiceImpl.class);
    private static final String DB_URL_PROPNAME = "db.service.hsqldb.url";
    private static final String DB_CACHE_ROWS_PROPNAME = "db.service.hsqldb.cache_rows";
    private static final String DB_LOB_FILE_PROPNAME = "db.service.hsqldb.lob_file_scale";
    private static final String DB_DEFRAG_LIMIT_PROPNAME = "db.service.hsqldb.defrag_limit";
    private static final String DB_LOG_DATA_PROPNAME = "db.service.hsqldb.log_data";
    private static final String DB_LOG_SIZE_PROPNAME = "db.service.hsqldb.log_size";
    private static final String DB_NIO_PROPNAME = "db.service.hsqldb.nio_data_file";
    private static final String DB_WRITE_DELAY_MILLIES_PROPNAME = "db.service.hsqldb.write_delay_millis";
    private static final String s_username = "sa";
    private static final String s_password = "";
    private static final Object s_init_lock;
    private static boolean s_inited;
    private ComponentContext m_ctx;
    private SystemService m_systemService;
    private JDBCPool m_connPool;

    static {
        try {
            DriverManager.registerDriver((Driver)new jdbcDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        s_init_lock = "init lock";
        s_inited = false;
    }

    public void setSystemService(SystemService systemService) {
        this.m_systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.m_systemService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        s_logger.info("activate...");
        this.m_ctx = componentContext;
        Object object = s_init_lock;
        synchronized (object) {
            if (!s_inited) {
                Connection conn = null;
                try {
                    try {
                        conn = this.getConnection();
                    }
                    catch (SQLException e) {
                        this.rollback(conn);
                        s_logger.error("Error during HsqdbService startup", (Throwable)e);
                        throw new ComponentException((Throwable)e);
                    }
                }
                finally {
                    this.close(conn);
                }
                try {
                    this.init();
                    s_inited = true;
                }
                catch (SQLException e) {
                    s_logger.error("Error during HsqdbService init", (Throwable)e);
                    throw new ComponentException((Throwable)e);
                }
            }
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("deactivate...");
        try {
            this.execute("SHUTDOWN");
            s_inited = false;
        }
        catch (SQLException e) {
            s_logger.error("Error during HsqlDbService shutdown", (Throwable)e);
            throw new ComponentException((Throwable)e);
        }
        try {
            if (this.m_connPool != null) {
                this.m_connPool.close(0);
                this.m_connPool = null;
            }
        }
        catch (SQLException e) {
            s_logger.error("Error during HsqlDbService connection close", (Throwable)e);
            throw new ComponentException((Throwable)e);
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.m_connPool == null) {
            String url = this.m_systemService.getProperties().getProperty(DB_URL_PROPNAME);
            s_logger.info("Opening database with url: " + url);
            this.m_connPool = new JDBCPool();
            this.m_connPool.setUrl(url);
            this.m_connPool.setUser(s_username);
            this.m_connPool.setPassword(s_password);
        }
        Connection conn = null;
        try {
            conn = this.m_connPool.getConnection();
        }
        catch (SQLException e) {
            s_logger.error("Error getting connection", (Throwable)e);
            this.closeSilently();
            throw e;
        }
        return conn;
    }

    public void rollback(Connection conn) {
        try {
            if (conn != null) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            s_logger.error("Error during Connection rollback.", (Throwable)e);
        }
    }

    public void close(ResultSet ... rss) {
        if (rss != null) {
            ResultSet[] resultSetArray = rss;
            int n = rss.length;
            int n2 = 0;
            while (n2 < n) {
                ResultSet rs = resultSetArray[n2];
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    s_logger.error("Error during ResultSet closing", (Throwable)e);
                }
                ++n2;
            }
        }
    }

    public void close(Statement ... stmts) {
        if (stmts != null) {
            Statement[] statementArray = stmts;
            int n = stmts.length;
            int n2 = 0;
            while (n2 < n) {
                Statement stmt = statementArray[n2];
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    s_logger.error("Error during Statement closing", (Throwable)e);
                }
                ++n2;
            }
        }
    }

    public void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            s_logger.error("Error during Connection closing", (Throwable)e);
        }
    }

    public boolean isLogDataEnabled() {
        boolean isLogDataEnabled = true;
        String sIsLogDataEnabled = this.m_systemService.getProperties().getProperty(DB_LOG_DATA_PROPNAME);
        if (sIsLogDataEnabled != null && !sIsLogDataEnabled.isEmpty()) {
            isLogDataEnabled = new Boolean(sIsLogDataEnabled);
        }
        return isLogDataEnabled;
    }

    private void init() throws SQLException {
        String useNio;
        String logSize;
        String logData;
        String defragLimit;
        String lobScale;
        this.execute("SET DATABASE TRANSACTION CONTROL LOCKS");
        this.execute("SET TRANSACTION READ WRITE, ISOLATION LEVEL READ COMMITTED");
        this.execute("SET AUTOCOMMIT FALSE");
        String writeDelayMillies = this.m_systemService.getProperties().getProperty(DB_WRITE_DELAY_MILLIES_PROPNAME);
        if (writeDelayMillies == null || writeDelayMillies.isEmpty()) {
            writeDelayMillies = "500";
        }
        this.execute("SET FILES WRITE DELAY " + writeDelayMillies + " MILLIS");
        this.execute("SET DATABASE DEFAULT TABLE TYPE CACHED");
        String cacheRows = this.m_systemService.getProperties().getProperty(DB_CACHE_ROWS_PROPNAME);
        if (cacheRows != null && !cacheRows.isEmpty()) {
            this.execute("SET FILES CACHE ROWS " + cacheRows);
        }
        if ((lobScale = this.m_systemService.getProperties().getProperty(DB_LOB_FILE_PROPNAME)) != null && !lobScale.isEmpty()) {
            this.execute("SET FILES LOB SCALE " + lobScale);
        }
        if ((defragLimit = this.m_systemService.getProperties().getProperty(DB_DEFRAG_LIMIT_PROPNAME)) != null && !defragLimit.isEmpty()) {
            this.execute("SET FILES DEFRAG " + defragLimit);
        }
        if ((logData = this.m_systemService.getProperties().getProperty(DB_LOG_DATA_PROPNAME)) != null && !logData.isEmpty()) {
            this.execute("SET FILES LOG " + logData.toUpperCase());
        }
        if ((logSize = this.m_systemService.getProperties().getProperty(DB_LOG_SIZE_PROPNAME)) != null && !logSize.isEmpty()) {
            this.execute("SET FILES LOG SIZE " + logSize);
        }
        if ((useNio = this.m_systemService.getProperties().getProperty(DB_NIO_PROPNAME)) != null && !useNio.isEmpty()) {
            this.execute("SET FILES NIO " + useNio.toUpperCase());
        }
    }

    private void execute(String sql) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.createStatement();
                stmt.execute(sql);
                conn.commit();
            }
            catch (SQLException e) {
                this.rollback(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.close(stmt);
            this.close(conn);
            throw throwable;
        }
        this.close(stmt);
        this.close(conn);
    }

    private void closeSilently() {
        try {
            try {
                if (this.m_connPool != null) {
                    this.m_connPool.close(0);
                }
            }
            catch (Exception e) {
                s_logger.warn("Error during HsqlDbService connection close", (Throwable)e);
                this.m_connPool = null;
            }
        }
        finally {
            this.m_connPool = null;
        }
    }
}

