/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudClientListener;
import org.eclipse.kura.core.cloud.CloudClientListenerAdapter;
import org.eclipse.kura.core.cloud.CloudServiceImpl;
import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.message.KuraPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudClientImpl
implements CloudClient,
CloudClientListener {
    private static final Logger s_logger = LoggerFactory.getLogger(CloudClientImpl.class);
    private String m_applicationId;
    private DataService m_dataService;
    private CloudServiceImpl m_cloudServiceImpl;
    private List<CloudClientListenerAdapter> m_listeners;

    protected CloudClientImpl(String applicationId, DataService dataService, CloudServiceImpl cloudServiceImpl) {
        this.m_applicationId = applicationId;
        this.m_dataService = dataService;
        this.m_cloudServiceImpl = cloudServiceImpl;
        this.m_listeners = new CopyOnWriteArrayList<CloudClientListenerAdapter>();
    }

    public String getApplicationId() {
        return this.m_applicationId;
    }

    public void release() {
        this.m_cloudServiceImpl.removeCloudClient(this);
    }

    public void addCloudClientListener(CloudClientListener cloudClientListener) {
        this.m_listeners.add(new CloudClientListenerAdapter(cloudClientListener));
    }

    public void removeCloudClientListener(CloudClientListener cloudClientListener) {
        ArrayList<CloudClientListenerAdapter> adapters = new ArrayList<CloudClientListenerAdapter>(this.m_listeners);
        for (CloudClientListenerAdapter adapter : adapters) {
            if (adapter.getCloudClientListenerAdapted() != cloudClientListener) continue;
            this.m_listeners.remove(adapter);
            break;
        }
    }

    public boolean isConnected() {
        return this.m_dataService.isConnected();
    }

    public int publish(String topic, KuraPayload payload, int qos, boolean retain) throws KuraException {
        boolean isControl = false;
        String appTopic = this.encodeTopic(topic, isControl);
        byte[] appPayload = this.m_cloudServiceImpl.encodePayload(payload);
        return this.m_dataService.publish(appTopic, appPayload, qos, retain, 5);
    }

    public int publish(String topic, KuraPayload payload, int qos, boolean retain, int priority) throws KuraException {
        boolean isControl = false;
        String appTopic = this.encodeTopic(topic, isControl);
        byte[] appPayload = this.m_cloudServiceImpl.encodePayload(payload);
        return this.m_dataService.publish(appTopic, appPayload, qos, retain, priority);
    }

    public int publish(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraException {
        boolean isControl = false;
        String appTopic = this.encodeTopic(topic, isControl);
        return this.m_dataService.publish(appTopic, payload, qos, retain, priority);
    }

    public int controlPublish(String topic, KuraPayload payload, int qos, boolean retain, int priority) throws KuraException {
        boolean isControl = true;
        String appTopic = this.encodeTopic(topic, isControl);
        byte[] appPayload = this.m_cloudServiceImpl.encodePayload(payload);
        return this.m_dataService.publish(appTopic, appPayload, qos, retain, priority);
    }

    public int controlPublish(String deviceId, String topic, KuraPayload payload, int qos, boolean retain, int priority) throws KuraException {
        boolean isControl = true;
        String appTopic = this.encodeTopic(deviceId, topic, isControl);
        byte[] appPayload = this.m_cloudServiceImpl.encodePayload(payload);
        return this.m_dataService.publish(appTopic, appPayload, qos, retain, priority);
    }

    public int controlPublish(String deviceId, String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraException {
        boolean isControl = true;
        String appTopic = this.encodeTopic(deviceId, topic, isControl);
        return this.m_dataService.publish(appTopic, payload, qos, retain, priority);
    }

    public void subscribe(String topic, int qos) throws KuraException {
        boolean isControl = false;
        String appTopic = this.encodeTopic(topic, isControl);
        this.m_dataService.subscribe(appTopic, qos);
    }

    public void controlSubscribe(String topic, int qos) throws KuraException {
        boolean isControl = true;
        String appTopic = this.encodeTopic(topic, isControl);
        this.m_dataService.subscribe(appTopic, qos);
    }

    public void unsubscribe(String topic) throws KuraException {
        boolean isControl = false;
        String appTopic = this.encodeTopic(topic, isControl);
        this.m_dataService.unsubscribe(appTopic);
    }

    public void controlUnsubscribe(String topic) throws KuraException {
        boolean isControl = true;
        String appTopic = this.encodeTopic(topic, isControl);
        this.m_dataService.unsubscribe(appTopic);
    }

    public List<Integer> getUnpublishedMessageIds() throws KuraException {
        String topicRegex = this.getAppTopicRegex();
        return this.m_dataService.getUnpublishedMessageIds(topicRegex);
    }

    public List<Integer> getInFlightMessageIds() throws KuraException {
        String topicRegex = this.getAppTopicRegex();
        return this.m_dataService.getInFlightMessageIds(topicRegex);
    }

    public List<Integer> getDroppedInFlightMessageIds() throws KuraException {
        String topicRegex = this.getAppTopicRegex();
        return this.m_dataService.getDroppedInFlightMessageIds(topicRegex);
    }

    public void onMessageArrived(String deviceId, String appTopic, KuraPayload payload, int qos, boolean retain) {
        for (CloudClientListener cloudClientListener : this.m_listeners) {
            cloudClientListener.onMessageArrived(deviceId, appTopic, payload, qos, retain);
        }
    }

    public void onControlMessageArrived(String deviceId, String appTopic, KuraPayload payload, int qos, boolean retain) {
        for (CloudClientListener cloudClientListener : this.m_listeners) {
            cloudClientListener.onControlMessageArrived(deviceId, appTopic, payload, qos, retain);
        }
    }

    public void onMessageConfirmed(int pubId, String appTopic) {
        for (CloudClientListener cloudClientListener : this.m_listeners) {
            cloudClientListener.onMessageConfirmed(pubId, appTopic);
        }
    }

    public void onMessagePublished(int pubId, String appTopic) {
        for (CloudClientListener cloudClientListener : this.m_listeners) {
            cloudClientListener.onMessagePublished(pubId, appTopic);
        }
    }

    public void onConnectionEstablished() {
        for (CloudClientListener cloudClientListener : this.m_listeners) {
            cloudClientListener.onConnectionEstablished();
        }
    }

    public void onConnectionLost() {
        for (CloudClientListener cloudClientListener : this.m_listeners) {
            cloudClientListener.onConnectionLost();
        }
    }

    private String encodeTopic(String topic, boolean isControl) {
        CloudServiceOptions options = this.m_cloudServiceImpl.getCloudServiceOptions();
        return this.encodeTopic(options.getTopicClientIdToken(), topic, isControl);
    }

    private String encodeTopic(String deviceId, String topic, boolean isControl) {
        CloudServiceOptions options = this.m_cloudServiceImpl.getCloudServiceOptions();
        StringBuilder sb = new StringBuilder();
        if (isControl) {
            sb.append(options.getTopicControlPrefix()).append(options.getTopicSeparator());
        }
        sb.append(options.getTopicAccountToken()).append(options.getTopicSeparator()).append(deviceId).append(options.getTopicSeparator()).append(this.m_applicationId);
        if (topic != null && !topic.isEmpty()) {
            sb.append(options.getTopicSeparator()).append(topic);
        }
        return sb.toString();
    }

    private String getAppTopicRegex() {
        CloudServiceOptions options = this.m_cloudServiceImpl.getCloudServiceOptions();
        StringBuilder sb = new StringBuilder();
        sb.append("^(").append("\\$EDC").append(options.getTopicSeparator()).append(")?").append(options.getTopicAccountToken()).append(options.getTopicSeparator()).append(".+").append(options.getTopicSeparator()).append(this.m_applicationId).append("(/.+)?");
        return sb.toString();
    }
}

