/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud.app.command;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.Cloudlet;
import org.eclipse.kura.cloud.CloudletTopic;
import org.eclipse.kura.cloud.app.command.KuraCommandRequestPayload;
import org.eclipse.kura.cloud.app.command.KuraCommandResponsePayload;
import org.eclipse.kura.cloud.app.command.ProcessMonitorThread;
import org.eclipse.kura.cloud.app.command.UnZip;
import org.eclipse.kura.command.PasswordCommandService;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraRequestPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandCloudApp
extends Cloudlet
implements ConfigurableComponent,
PasswordCommandService {
    private static final Logger s_logger = LoggerFactory.getLogger(CommandCloudApp.class);
    private static final String EDC_PASSWORD_METRIC_NAME = "command.password";
    private static final String COMMAND_ENABLED_ID = "command.enable";
    private static final String COMMAND_PASSWORD_ID = "command.password.value";
    private static final String COMMAND_WORKDIR_ID = "command.working.directory";
    private static final String COMMAND_TIMEOUT_ID = "command.timeout";
    private static final String COMMAND_ENVIRONMENT_ID = "command.environment";
    public static final String APP_ID = "CMD-V1";
    private Map<String, Object> properties;
    private ComponentContext compCtx;
    public static final String RESOURCE_COMMAND = "command";

    public CommandCloudApp() {
        super(APP_ID);
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        s_logger.info("Bundle CMD-V1 has started with config!");
        this.compCtx = componentContext;
        this.updated(properties);
    }

    public void updated(Map<String, Object> properties) {
        s_logger.info("updated...: " + properties);
        this.properties = properties;
        boolean verificationEnabled = (Boolean)properties.get(COMMAND_ENABLED_ID);
        if (verificationEnabled) {
            super.activate(this.compCtx);
        } else if (this.getCloudApplicationClient() != null) {
            super.deactivate(this.compCtx);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("Bundle CMD-V1 is deactivating!");
        if (this.getCloudApplicationClient() != null) {
            super.deactivate(this.compCtx);
        }
    }

    protected void doExec(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        String[] resources = reqTopic.getResources();
        if (resources == null || resources.length != 1) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected one resource but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        if (!resources[0].equals(RESOURCE_COMMAND)) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Cannot find resource with name: {}", (Object)resources[0]);
            respPayload.setResponseCode(404);
            return;
        }
        s_logger.info("EXECuting resource: {}", (Object)RESOURCE_COMMAND);
        KuraCommandResponsePayload commandResp = this.execute(reqPayload);
        for (String name : commandResp.metricNames()) {
            Object value = commandResp.getMetric(name);
            respPayload.addMetric(name, value);
        }
        respPayload.setBody(commandResp.getBody());
    }

    public KuraCommandResponsePayload execute(KuraRequestPayload reqPayload) {
        KuraCommandRequestPayload commandReq = new KuraCommandRequestPayload((KuraPayload)reqPayload);
        String receivedPassword = (String)commandReq.getMetric(EDC_PASSWORD_METRIC_NAME);
        String commandPassword = (String)this.properties.get(COMMAND_PASSWORD_ID);
        KuraCommandResponsePayload commandResp = new KuraCommandResponsePayload(200);
        boolean isExecutionAllowed = this.verifyPasswords(commandPassword, receivedPassword);
        if (isExecutionAllowed) {
            String command = commandReq.getCommand();
            if (command == null) {
                s_logger.error("null command");
                commandResp.setResponseCode(400);
            }
            String[] cmdarray = this.prepareCommandArray(commandReq, command);
            String[] envp = this.getEnvironment(commandReq);
            String dir = this.getDir(commandReq);
            byte[] zipBytes = commandReq.getZipBytes();
            if (zipBytes != null) {
                try {
                    UnZip.unZipBytes(zipBytes, dir);
                }
                catch (IOException e) {
                    s_logger.error("Error unzipping command zip bytes", (Throwable)e);
                    commandResp.setException(e);
                }
            }
            Process proc = null;
            try {
                proc = this.createExecutionProcess(dir, cmdarray, envp);
            }
            catch (Throwable t) {
                s_logger.error("Error executing command {}", t);
                commandResp.setResponseCode(500);
                commandResp.setException(t);
            }
            boolean runAsync = commandReq.isRunAsync() != null ? commandReq.isRunAsync() : false;
            int timeout = this.getTimeout(commandReq);
            ProcessMonitorThread pmt = null;
            pmt = new ProcessMonitorThread(proc, commandReq.getStdin(), timeout);
            pmt.start();
            if (!runAsync) {
                try {
                    pmt.join();
                    this.prepareResponseNoTimeout(commandResp, pmt);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    pmt.interrupt();
                    this.prepareTimeoutResponse(commandResp, pmt);
                }
            }
        } else {
            s_logger.error("Password required but not correct and/or missing");
            commandResp.setResponseCode(500);
            commandResp.setExceptionMessage("Password missing or not correct");
        }
        return commandResp;
    }

    public String execute(String cmd, String password) throws KuraException {
        boolean verificationEnabled = (Boolean)this.properties.get(COMMAND_ENABLED_ID);
        if (verificationEnabled) {
            String commandPassword = (String)this.properties.get(COMMAND_PASSWORD_ID);
            boolean isExecutionAllowed = this.verifyPasswords(commandPassword, password);
            if (isExecutionAllowed) {
                String[] cmdArray = cmd.split(" ");
                String defaultDir = this.getDefaultWorkDir();
                String[] environment = this.getDefaultEnvironment();
                try {
                    Process proc = this.createExecutionProcess(defaultDir, cmdArray, environment);
                    int timeout = this.getDefaultTimeout();
                    ProcessMonitorThread pmt = null;
                    pmt = new ProcessMonitorThread(proc, null, timeout);
                    pmt.start();
                    try {
                        pmt.join();
                        if (pmt.getExitValue() == 0) {
                            return pmt.getStdout();
                        }
                        return pmt.getStderr();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        pmt.interrupt();
                        throw KuraException.internalError((Throwable)e);
                    }
                }
                catch (IOException ex) {
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)ex, new Object[0]);
                }
            }
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    private String getDefaultWorkDir() {
        return (String)this.properties.get(COMMAND_WORKDIR_ID);
    }

    private int getDefaultTimeout() {
        return (Integer)this.properties.get(COMMAND_TIMEOUT_ID);
    }

    private String[] getDefaultEnvironment() {
        String envString = (String)this.properties.get(COMMAND_ENVIRONMENT_ID);
        if (envString != null) {
            return envString.split(" ");
        }
        return null;
    }

    private String getDir(KuraCommandRequestPayload req) {
        String dir = req.getWorkingDir();
        String defaultDir = this.getDefaultWorkDir();
        if (dir != null && !dir.isEmpty()) {
            return dir;
        }
        return defaultDir;
    }

    private int getTimeout(KuraCommandRequestPayload req) {
        Integer timeout = req.getTimeout();
        int defaultTimeout = this.getDefaultTimeout();
        if (timeout != null) {
            return timeout;
        }
        return defaultTimeout;
    }

    private String[] getEnvironment(KuraCommandRequestPayload req) {
        String[] envp = req.getEnvironmentPairs();
        String[] defaultEnv = this.getDefaultEnvironment();
        if (envp != null && envp.length != 0) {
            return envp;
        }
        return defaultEnv;
    }

    private boolean verifyPasswords(String commandPassword, String receivedPassword) {
        if (commandPassword == null && receivedPassword == null) {
            return true;
        }
        return commandPassword != null && commandPassword.equals(receivedPassword);
    }

    private Process createExecutionProcess(String dir, String[] cmdarray, String[] envp) throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process proc = null;
        File fileDir = dir == null ? null : new File(dir);
        proc = rt.exec(cmdarray, envp, fileDir);
        return proc;
    }

    private String[] prepareCommandArray(KuraCommandRequestPayload req, String command) {
        String[] args = req.getArguments();
        int argsCount = args != null ? args.length : 0;
        String[] cmdarray = new String[1 + argsCount];
        cmdarray[0] = command;
        int i = 0;
        while (i < argsCount) {
            cmdarray[1 + i] = args[i];
            ++i;
        }
        i = 0;
        while (i < cmdarray.length) {
            s_logger.debug("cmdarray: {}", (Object)cmdarray[i]);
            ++i;
        }
        return cmdarray;
    }

    private void prepareResponseNoTimeout(KuraCommandResponsePayload resp, ProcessMonitorThread pmt) {
        if (pmt.getException() != null) {
            resp.setResponseCode(500);
            resp.setException(pmt.getException());
            resp.setStderr(pmt.getStderr());
            resp.setStdout(pmt.getStdout());
        } else {
            resp.setStderr(pmt.getStderr());
            resp.setStdout(pmt.getStdout());
            resp.setTimedout(pmt.isTimedOut());
            if (!pmt.isTimedOut()) {
                resp.setExitCode(pmt.getExitValue());
            }
        }
    }

    private void prepareTimeoutResponse(KuraCommandResponsePayload resp, ProcessMonitorThread pmt) {
        resp.setStderr(pmt.getStderr());
        resp.setStdout(pmt.getStdout());
        resp.setTimedout(true);
    }
}

