/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.FactoryConfigurationError;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraPartialSuccessException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.core.configuration.CloudConfigurationHandler;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.ComponentMetaTypeBundleTracker;
import org.eclipse.kura.core.configuration.ConfigurableComponentTracker;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.core.configuration.util.CollectionsUtil;
import org.eclipse.kura.core.configuration.util.ComponentUtil;
import org.eclipse.kura.core.configuration.util.StringUtil;
import org.eclipse.kura.core.configuration.util.XmlUtil;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationServiceImpl
implements ConfigurationService,
ConfigurationListener {
    private static final Logger s_logger = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private ComponentContext m_ctx;
    private CloudConfigurationHandler m_cloudHandler;
    private ServiceTracker<?, ?> m_serviceTracker;
    private BundleTracker<Bundle> m_bundleTracker;
    private MetaTypeService m_metaTypeService;
    private ConfigurationAdmin m_configurationAdmin;
    private SystemService m_systemService;
    private CryptoService m_cryptoService;
    private Set<String> m_allPids = new HashSet<String>();
    private Set<String> m_selfConfigComponents = new HashSet<String>();
    private Map<String, Tocd> m_ocds;
    private Set<String> m_pendingConfigurationPids = new HashSet<String>();

    public void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.m_configurationAdmin = configAdmin;
    }

    public void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.m_configurationAdmin = null;
    }

    public void setMetaTypeService(MetaTypeService metaTypeService) {
        this.m_metaTypeService = metaTypeService;
    }

    public void unsetMetaTypeService(MetaTypeService metaTypeService) {
        this.m_metaTypeService = null;
    }

    public void setSystemService(SystemService systemService) {
        this.m_systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.m_systemService = null;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.m_cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        this.m_cryptoService = null;
    }

    public ConfigurationServiceImpl() {
        this.m_ocds = new HashMap<String, Tocd>();
    }

    protected void activate(ComponentContext componentContext) throws InvalidSyntaxException {
        s_logger.info("activate...");
        this.m_ctx = componentContext;
        this.m_ctx.getBundleContext().registerService(ConfigurationListener.class.getName(), (Object)this, null);
        try {
            this.loadLatestSnapshotInConfigAdmin();
        }
        catch (Exception e) {
            throw new ComponentException("Error loading latest snapshot", (Throwable)e);
        }
        s_logger.info("Trackers being opened...");
        this.m_cloudHandler = new CloudConfigurationHandler(this.m_ctx.getBundleContext(), this, this.m_systemService);
        this.m_cloudHandler.open();
        this.m_serviceTracker = new ConfigurableComponentTracker(this.m_ctx.getBundleContext(), this);
        this.m_serviceTracker.open(true);
        this.m_bundleTracker = new ComponentMetaTypeBundleTracker(this.m_ctx.getBundleContext(), this.m_configurationAdmin, this);
        this.m_bundleTracker.open();
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("deactivate...");
        if (this.m_cloudHandler != null) {
            this.m_cloudHandler.close();
        }
        if (this.m_serviceTracker != null) {
            this.m_serviceTracker.close();
        }
        if (this.m_bundleTracker != null) {
            this.m_bundleTracker.close();
        }
    }

    public synchronized void configurationEvent(ConfigurationEvent event) {
        String pid = event.getPid();
        if (this.m_pendingConfigurationPids.contains(pid)) {
            this.m_pendingConfigurationPids.remove(pid);
            return;
        }
        try {
            if (this.m_allPids.contains(pid)) {
                s_logger.info("ConfigurationEvent for tracked ConfigurableComponent with pid: {}", (Object)pid);
                this.snapshot();
            }
        }
        catch (Exception e) {
            s_logger.error("Error taking snapshot after ConfigurationEvent", (Throwable)e);
        }
    }

    public boolean hasConfigurableComponent(String pid) {
        return this.m_allPids.contains(pid);
    }

    public Set<String> getConfigurableComponentPids() {
        if (this.m_allPids.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_allPids);
    }

    public List<ComponentConfiguration> getComponentConfigurations() throws KuraException {
        ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
        ArrayList<String> allPids = new ArrayList<String>(this.m_allPids);
        ComponentConfiguration cc = null;
        for (String pid : allPids) {
            try {
                cc = null;
                cc = !this.m_selfConfigComponents.contains(pid) ? this.getConfigurableComponentConfiguration(pid) : this.getSelfConfiguringComponentConfiguration(pid);
                if (cc == null) continue;
                configs.add(cc);
            }
            catch (Exception e) {
                s_logger.error("Error getting configuration for component " + pid, (Throwable)e);
                throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[]{"Error getting configuration for component " + pid});
            }
        }
        return configs;
    }

    public ComponentConfiguration getComponentConfiguration(String pid) throws KuraException {
        ComponentConfiguration cc = null;
        cc = !this.m_selfConfigComponents.contains(pid) ? this.getConfigurableComponentConfiguration(pid) : this.getSelfConfiguringComponentConfiguration(pid);
        return cc;
    }

    public synchronized void updateConfiguration(String pidToUpdate, Map<String, Object> propertiesToUpdate) throws KuraException {
        boolean snapshotOnConfirmation = false;
        this.updateConfigurationInternal(pidToUpdate, propertiesToUpdate, snapshotOnConfirmation);
        ComponentConfiguration cc = null;
        ComponentConfigurationImpl cci = null;
        Map props = null;
        ArrayList<ComponentConfigurationImpl> configs = new ArrayList<ComponentConfigurationImpl>();
        ArrayList<String> allPids = new ArrayList<String>(this.m_allPids);
        for (String pid : allPids) {
            if (pid.equals(pidToUpdate)) {
                cci = new ComponentConfigurationImpl(pid, null, propertiesToUpdate);
                configs.add(cci);
                continue;
            }
            cc = !this.m_selfConfigComponents.contains(pid) ? this.getConfigurableComponentConfiguration(pid) : this.getSelfConfiguringComponentConfiguration(pid);
            if (cc == null || cc.getPid() == null || !cc.getPid().equals(pid)) continue;
            props = cc.getConfigurationProperties();
            cci = new ComponentConfigurationImpl(pid, null, props);
            configs.add(cci);
        }
        this.saveSnapshot(configs);
    }

    public long snapshot() throws KuraException {
        s_logger.info("Writing snapshot - Getting component configurations...");
        ComponentConfiguration cc = null;
        ComponentConfigurationImpl cci = null;
        Map props = null;
        ArrayList<ComponentConfigurationImpl> configs = new ArrayList<ComponentConfigurationImpl>();
        ArrayList<String> allPids = new ArrayList<String>(this.m_allPids);
        for (String pid : allPids) {
            cc = !this.m_selfConfigComponents.contains(pid) ? this.getConfigurableComponentConfiguration(pid) : this.getSelfConfiguringComponentConfiguration(pid);
            if (cc == null || cc.getPid() == null || !cc.getPid().equals(pid)) continue;
            props = cc.getConfigurationProperties();
            cci = new ComponentConfigurationImpl(pid, null, props);
            configs.add(cci);
        }
        return this.saveSnapshot(configs);
    }

    public long rollback() throws KuraException {
        Set<Long> ids = this.getSnapshots();
        if (ids.size() < 2) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_NOT_FOUND, null, new Object[]{"No Snapshot Available"});
        }
        Long[] snapshots = ids.toArray(new Long[0]);
        Long id = snapshots[ids.size() - 2];
        this.rollback(id);
        return id;
    }

    public synchronized void rollback(long id) throws KuraException {
        XmlComponentConfigurations xmlConfigs = this.loadSnapshot(id);
        s_logger.info("Rolling back to snapshot {}...", (Object)id);
        HashSet<String> snapshotPids = new HashSet<String>();
        boolean snapshotOnConfirmation = false;
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        List<ComponentConfigurationImpl> configs = xmlConfigs.getConfigurations();
        for (ComponentConfigurationImpl config : configs) {
            if (config == null) continue;
            try {
                this.updateConfigurationInternal(config.getPid(), config.getConfigurationProperties(), snapshotOnConfirmation);
            }
            catch (Throwable t) {
                s_logger.warn("Error during rollback for component " + config.getPid(), t);
                causes.add(t);
            }
            snapshotPids.add(config.getPid());
        }
        HashSet<String> pids = new HashSet<String>(this.m_allPids);
        pids.removeAll(this.m_selfConfigComponents);
        pids.removeAll(snapshotPids);
        for (String pid : pids) {
            s_logger.info("Rolling back to default configuration for component pid: '{}'", (Object)pid);
            Bundle bundle = this.m_ctx.getBundleContext().getServiceReference(pid).getBundle();
            try {
                Tocd ocd = ComponentUtil.readObjectClassDefinition(bundle, pid);
                Map<String, Object> defaults = ComponentUtil.getDefaultProperties(ocd);
                this.updateConfigurationInternal(pid, defaults, snapshotOnConfirmation);
            }
            catch (Throwable t) {
                s_logger.warn("Error during rollback for component " + pid, t);
                causes.add(t);
            }
        }
        if (causes.size() > 0) {
            throw new KuraPartialSuccessException("Rollback", causes);
        }
        this.saveSnapshot(configs);
    }

    public Set<Long> getSnapshots() throws KuraException {
        return this.getSnapshotsInternal();
    }

    public List<ComponentConfiguration> getSnapshot(long sid) throws KuraException {
        ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
        XmlComponentConfigurations xmlConfigs = this.loadSnapshot(sid);
        if (xmlConfigs != null) {
            configs.addAll(xmlConfigs.getConfigurations());
        }
        return configs;
    }

    public synchronized void updateConfigurations(List<ComponentConfiguration> configsToUpdate) throws KuraException {
        boolean snapshotOnConfirmation = false;
        ArrayList<KuraException> causes = new ArrayList<KuraException>();
        for (ComponentConfiguration config : configsToUpdate) {
            if (config == null) continue;
            try {
                this.updateConfigurationInternal(config.getPid(), config.getConfigurationProperties(), snapshotOnConfirmation);
            }
            catch (KuraException e) {
                s_logger.warn("Error during updateConfigurations for component " + config.getPid(), (Throwable)e);
                causes.add(e);
            }
        }
        ComponentConfiguration cc = null;
        ComponentConfigurationImpl cci = null;
        Map props = null;
        ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
        ArrayList<String> allPids = new ArrayList<String>(this.m_allPids);
        for (String pid : allPids) {
            boolean isConfigToUpdate = false;
            for (ComponentConfiguration configToUpdate : configsToUpdate) {
                if (!configToUpdate.getPid().equals(pid)) continue;
                isConfigToUpdate = true;
                configs.add(configToUpdate);
                break;
            }
            if (isConfigToUpdate || (cc = !this.m_selfConfigComponents.contains(pid) ? this.getConfigurableComponentConfiguration(pid) : this.getSelfConfiguringComponentConfiguration(pid)) == null || cc.getPid() == null || !cc.getPid().equals(pid)) continue;
            props = cc.getConfigurationProperties();
            cci = new ComponentConfigurationImpl(pid, null, props);
            configs.add(cci);
        }
        this.saveSnapshot(configs);
        if (causes.size() > 0) {
            throw new KuraPartialSuccessException("updateConfigurations", causes);
        }
    }

    synchronized void registerComponentConfiguration(Bundle bundle, String pid) throws KuraException {
        if (!this.m_allPids.contains(pid)) {
            s_logger.info("Registration of ConfigurableComponent {} by {}...", (Object)pid, (Object)this);
            try {
                this.m_allPids.add(pid);
                Tocd ocd = null;
                try {
                    ocd = ComponentUtil.readObjectClassDefinition(bundle, pid);
                    if (ocd != null) {
                        s_logger.info("Registering {} with ocd: {} ...", (Object)pid, (Object)ocd);
                        this.m_ocds.put(pid, ocd);
                    }
                }
                catch (Throwable t) {
                    s_logger.error("Error reading ObjectClassDefinition for " + pid, t);
                }
                s_logger.info("Registration Completed for Component {}.", (Object)pid);
            }
            catch (Exception e) {
                s_logger.error("Error initializing Component Configuration", (Throwable)e);
            }
        }
    }

    synchronized void registerSelfConfiguringComponent(String pid) throws KuraException {
        if (pid == null) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR);
        }
        this.m_allPids.add(pid);
        this.m_selfConfigComponents.add(pid);
    }

    void unregisterComponentConfiguration(String pid) {
        if (pid == null) {
            return;
        }
        s_logger.debug("Removing component configuration for " + pid);
        this.m_allPids.remove(pid);
        this.m_ocds.remove(pid);
        this.m_selfConfigComponents.remove(pid);
    }

    void updateConfigurationInternal(String pid, Map<String, Object> properties, boolean snapshotOnConfirmation) throws KuraException {
        boolean changed;
        ComponentConfiguration config;
        s_logger.debug("Attempting update configuration for {}", (Object)pid);
        if (!this.m_allPids.contains(pid)) {
            s_logger.info("UpdatingConfiguration ignored as ConfigurableComponent {} is NOT tracked.", (Object)pid);
            return;
        }
        if (properties == null) {
            s_logger.info("UpdatingConfiguration ignored as properties for ConfigurableComponent {} are NULL.", (Object)pid);
            return;
        }
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>(properties);
        OCD registerdOCD = this.m_ocds.get(pid);
        if (registerdOCD == null && (config = this.getSelfConfiguringComponentConfiguration(pid)) != null) {
            registerdOCD = config.getDefinition();
        }
        if (registerdOCD != null && (changed = this.mergeWithDefaults(registerdOCD, mergedProperties))) {
            s_logger.info("mergeWithDefaults returned " + changed);
        }
        try {
            if (!this.m_selfConfigComponents.contains(pid)) {
                BundleContext ctx = this.m_ctx.getBundleContext();
                ObjectClassDefinition ocd = null;
                ocd = ComponentUtil.getObjectClassDefinition(ctx, pid);
                this.validateProperties(pid, ocd, mergedProperties);
            }
            if (!snapshotOnConfirmation) {
                this.m_pendingConfigurationPids.add(pid);
            } else {
                s_logger.info("Snapshot on EventAdmin configuration will be taken for {}.", (Object)pid);
            }
            config = this.m_configurationAdmin.getConfiguration(pid);
            config.update(CollectionsUtil.mapToDictionary(mergedProperties));
            s_logger.info("Updating Configuration of ConfigurableComponent {} ... Done.", (Object)pid);
        }
        catch (IOException e) {
            s_logger.error("Error updating Configuration of ConfigurableComponent " + pid, (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_UPDATE, (Throwable)e, new Object[]{pid});
        }
    }

    XmlComponentConfigurations loadSnapshot(long id) throws KuraException, FactoryConfigurationError {
        File fSnapshot = this.getSnapshotFile(id);
        if (!fSnapshot.exists()) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_NOT_FOUND, new Object[]{fSnapshot.getAbsolutePath()});
        }
        XmlComponentConfigurations xmlConfigs = null;
        try {
            FileReader fr = new FileReader(fSnapshot);
            xmlConfigs = XmlUtil.unmarshal(fr, XmlComponentConfigurations.class);
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
        return xmlConfigs;
    }

    private synchronized long saveSnapshot(List<? extends ComponentConfiguration> configs) throws KuraException {
        Long[] snapshots;
        Long lastestID;
        ArrayList<ComponentConfigurationImpl> configImpls = new ArrayList<ComponentConfigurationImpl>();
        for (ComponentConfiguration componentConfiguration : configs) {
            if (!(componentConfiguration instanceof ComponentConfigurationImpl)) continue;
            configImpls.add((ComponentConfigurationImpl)componentConfiguration);
        }
        XmlComponentConfigurations xmlComponentConfigurations = new XmlComponentConfigurations();
        xmlComponentConfigurations.setConfigurations(configImpls);
        long sid = new Date().getTime();
        Set<Long> snapshotIDs = this.getSnapshots();
        if (snapshotIDs != null && snapshotIDs.size() > 0 && (lastestID = (snapshots = snapshotIDs.toArray(new Long[0]))[snapshotIDs.size() - 1]) != null && sid <= lastestID) {
            s_logger.warn("Snapshot ID: {} is in the past. Adjusting ID to: {} + 1", (Object)sid, (Object)lastestID);
            sid = lastestID + 1L;
        }
        File fSnapshot = this.getSnapshotFile(sid);
        s_logger.info("Writing snapshot - Saving {}...", (Object)fSnapshot.getAbsolutePath());
        try {
            FileOutputStream fos = new FileOutputStream(fSnapshot);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            XmlUtil.marshal(xmlComponentConfigurations, osw);
            osw.flush();
            fos.flush();
            fos.getFD().sync();
            osw.close();
            fos.close();
        }
        catch (Throwable t) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, t, new Object[0]);
        }
        s_logger.info("Writing snapshot - Saving {}... Done.", (Object)fSnapshot.getAbsolutePath());
        this.garbageCollectionOldSnapshots();
        return sid;
    }

    private ComponentConfiguration getConfigurableComponentConfiguration(String pid) {
        ComponentConfigurationImpl cc = null;
        try {
            Tocd ocd = this.m_ocds.get(pid);
            Configuration cfg = this.m_configurationAdmin.getConfiguration(pid);
            Map<String, Object> props = CollectionsUtil.dictionaryToMap(cfg.getProperties(), ocd);
            cc = new ComponentConfigurationImpl(pid, ocd, props);
        }
        catch (Exception e) {
            s_logger.error("Error getting Configuration for component: " + pid + ". Ignoring it.", (Throwable)e);
        }
        return cc;
    }

    /*
     * Exception decompiling
     */
    private ComponentConfiguration getSelfConfiguringComponentConfiguration(String pid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TreeSet<Long> getSnapshotsInternal() {
        File fConfigDir;
        File[] files;
        TreeSet<Long> ids = new TreeSet<Long>();
        String configDir = this.getSnapshotsDirectory();
        if (configDir != null && (files = (fConfigDir = new File(configDir)).listFiles()) != null) {
            Pattern p = Pattern.compile("snapshot_([0-9]+)\\.xml");
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Matcher m = p.matcher(file.getName());
                if (m.matches()) {
                    ids.add(Long.parseLong(m.group(1)));
                }
                ++n2;
            }
        }
        return ids;
    }

    String getSnapshotsDirectory() {
        String configDirs = this.m_systemService.getKuraSnapshotsDirectory();
        return configDirs;
    }

    private File getSnapshotFile(long id) {
        String configDir = this.getSnapshotsDirectory();
        StringBuilder sbSnapshot = new StringBuilder(configDir);
        sbSnapshot.append(File.separator).append("snapshot_").append(id).append(".xml");
        String snapshot = sbSnapshot.toString();
        return new File(snapshot);
    }

    private void garbageCollectionOldSnapshots() {
        TreeSet<Long> sids = this.getSnapshotsInternal();
        int currCount = sids.size();
        int maxCount = this.m_systemService.getKuraSnapshotsCount();
        while (currCount > maxCount) {
            File fSnapshot;
            long sid = sids.pollFirst();
            if (sid == 0L || !(fSnapshot = this.getSnapshotFile(sid)).exists()) continue;
            s_logger.info("Snapshots Garbage Collector. Deleting {}", (Object)fSnapshot.getAbsolutePath());
            fSnapshot.delete();
            --currCount;
        }
    }

    private void loadLatestSnapshotInConfigAdmin() throws KuraException {
        Set<Long> snapshotIDs = this.getSnapshots();
        if (snapshotIDs == null || snapshotIDs.size() == 0) {
            return;
        }
        Long[] snapshots = snapshotIDs.toArray(new Long[0]);
        Long lastestID = snapshots[snapshotIDs.size() - 1];
        String configDir = this.getSnapshotsDirectory();
        StringBuilder sbSnapshot = new StringBuilder(configDir);
        sbSnapshot.append(File.separator).append("snapshot_").append(lastestID).append(".xml");
        String snapshot = sbSnapshot.toString();
        File fSnapshot = new File(snapshot);
        if (!fSnapshot.exists()) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_NOT_FOUND, new Object[]{snapshot});
        }
        s_logger.info("Loading init configurations from: {}...", (Object)snapshot);
        XmlComponentConfigurations xmlConfigs = null;
        try {
            FileReader fr = new FileReader(fSnapshot);
            xmlConfigs = XmlUtil.unmarshal(fr, XmlComponentConfigurations.class);
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
        List<ComponentConfigurationImpl> configs = xmlConfigs.getConfigurations();
        for (ComponentConfigurationImpl config : configs) {
            if (config == null) continue;
            try {
                s_logger.debug("Pushing config to config admin: {}", (Object)config.getPid());
                Configuration cfg = this.m_configurationAdmin.getConfiguration(config.getPid());
                cfg.update(CollectionsUtil.mapToDictionary(config.getConfigurationProperties()));
                this.m_pendingConfigurationPids.add(config.getPid());
            }
            catch (IOException e) {
                s_logger.warn("Error seeding initial properties to ConfigAdmin for service: " + config.getPid(), (Throwable)e);
            }
        }
    }

    private void validateProperties(String pid, ObjectClassDefinition ocd, Map<String, Object> updatedProps) throws KuraException {
        if (ocd != null) {
            HashMap<String, AttributeDefinition> attrDefs = new HashMap<String, AttributeDefinition>();
            AttributeDefinition[] defs = ocd.getAttributeDefinitions(-1);
            AttributeDefinition[] attributeDefinitionArray = defs;
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDefinition def = attributeDefinitionArray[n2];
                attrDefs.put(def.getID(), def);
                ++n2;
            }
            for (String key : updatedProps.keySet()) {
                String result;
                Object objectValue;
                String stringValue;
                AttributeDefinition attrDef = (AttributeDefinition)attrDefs.get(key);
                if (attrDef == null || (stringValue = StringUtil.valueToString(objectValue = updatedProps.get(key))) == null || (result = attrDef.validate(stringValue)) == null || result.isEmpty()) continue;
                throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, new Object[]{String.valueOf(attrDef.getID()) + ": " + result});
            }
            OCD ocdFull = this.m_ocds.get(pid);
            if (ocdFull != null) {
                for (AD attrDef : ocdFull.getAD()) {
                    if (!attrDef.isRequired() || updatedProps.get(attrDef.getId()) != null) continue;
                    throw new KuraException(KuraErrorCode.CONFIGURATION_REQUIRED_ATTRIBUTE_MISSING, new Object[]{attrDef.getId()});
                }
            }
        }
    }

    boolean mergeWithDefaults(OCD ocd, Map<String, Object> properties) throws KuraException {
        boolean changed = false;
        Set<String> keys = properties.keySet();
        Map<String, Object> defaults = ComponentUtil.getDefaultProperties(ocd);
        Set<String> defaultsKeys = defaults.keySet();
        defaultsKeys.removeAll(keys);
        if (!defaultsKeys.isEmpty()) {
            changed = true;
            s_logger.info("Merging configuration for pid: {}", (Object)ocd.getId());
            for (String key : defaultsKeys) {
                Object value = defaults.get(key);
                properties.put(key, value);
                s_logger.debug("Merged configuration properties with property with name: {} and default value {}", (Object)key, value);
            }
        }
        return changed;
    }
}

