/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.sdk.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.sdk.Messages;
import org.polarsys.kitalpha.ad.viewpoint.sdk.manager.BundleManager;

public class ReloadBundleAction
implements IObjectActionDelegate {
    private Shell shell;
    private IProject project;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (BundleManager.INSTANCE.isManaged(this.project)) {
            String name = this.project.getName();
            try {
                BundleManager.INSTANCE.unLoad(name);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.shell, (String)Messages.ManageBundle_error_title4, (String)Messages.ManageBundle_error_message);
                AD_Log.getDefault().logError(Messages.ManageBundle_error_title4, (Throwable)e);
            }
            try {
                BundleManager.INSTANCE.load(name);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.shell, (String)Messages.ManageBundle_error_title5, (String)Messages.ManageBundle_error_message);
                AD_Log.getDefault().logError(Messages.ManageBundle_error_title5, (Throwable)e);
            }
            return;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sselect;
        this.project = null;
        if (selection instanceof IStructuredSelection && (sselect = (IStructuredSelection)selection).size() == 1) {
            if (sselect.getFirstElement() instanceof IProject) {
                this.project = (IProject)sselect.getFirstElement();
            } else if (sselect.getFirstElement() instanceof IJavaProject) {
                this.project = ((IJavaProject)sselect.getFirstElement()).getProject();
            }
        }
        action.setEnabled(this.project != null && this.project.isAccessible() && PDE.hasPluginNature((IProject)this.project) && BundleManager.INSTANCE.isManaged(this.project));
    }
}

