/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.common.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.image.ImageManagerProvider;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.kitalpha.richtext.common.impl.MDERichTextPropertyChangeListenerSupport;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.common.intf.SaveStrategy;
import org.polarsys.kitalpha.richtext.common.messages.Messages;
import org.polarsys.kitalpha.richtext.common.util.MDERichTextHelper;

public abstract class AbstractMDERichTextWidget
implements MDERichTextWidget {
    private static final MDERichTextPropertyChangeListenerSupport listenersSupports = new MDERichTextPropertyChangeListenerSupport();
    private EObject owner;
    private EStructuralFeature feature;
    private SaveStrategy saveStrategy;
    public static final String WIDGET_SAVED_PROP = "widgetSaved";
    private boolean isLoading = false;
    private final SaveStrategy DEFAULT_SAVE_STRATEGY = new SaveStrategy(){

        @Override
        public void save(String editorText, EObject objectOwner, EStructuralFeature objectFeature) {
            objectOwner.eSet(objectFeature, (Object)editorText);
        }
    };

    public AbstractMDERichTextWidget(Composite parent) {
        this.setSaveStrategy(this.DEFAULT_SAVE_STRATEGY);
    }

    public AbstractMDERichTextWidget(Composite parent, int style) {
        this(parent);
    }

    @Override
    public EObject getElement() {
        return this.owner;
    }

    @Override
    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public void bind(EObject owner, EStructuralFeature feature) {
        if (this.owner != null && this.feature != null && this.owner != owner && this.hasFocus()) {
            this.saveContent();
        }
        this.owner = owner;
        this.feature = feature;
        this.setBaseHrefPath(MDERichTextHelper.getProjectPath(owner));
        this.loadContent();
    }

    @Override
    public void loadContent() {
        this.areNotNull(this.getElement(), this.getFeature());
        Object value = this.getElement().eGet(this.getFeature());
        String text = (String)(value instanceof String ? value : "");
        text = ImageManagerProvider.getImageManager().computeAndConvertPathsToHtmlFromOriginal(this.getElement(), text);
        this.setText(text);
    }

    @Override
    public final void saveContent() {
        this.areNotNull(this.getElement(), this.getFeature());
        String text = this.getText();
        if (text != null && this.isEditable()) {
            text = ImageManagerProvider.getImageManager().convertToOriginalPathFromPathUsedForHtml(this.getElement(), text);
            Object currentValue = this.getElement().eGet(this.getFeature());
            if (text != null && !text.equals(currentValue)) {
                this.getSaveStrategy().save(text, this.getElement(), this.getFeature());
                Object newValue = this.getElement().eGet(this.getFeature());
                if (currentValue != newValue) {
                    this.loadContent();
                }
                this.firePropertyChangeEvent(new PropertyChangeEvent(this, WIDGET_SAVED_PROP, null, null));
            }
        }
    }

    @Override
    public final void setSaveStrategy(SaveStrategy strategy) {
        Assert.isLegal((strategy != null ? 1 : 0) != 0, (String)Messages.RichTextWidget_Common_NullableStrategy_Error);
        this.saveStrategy = strategy;
    }

    @Override
    public SaveStrategy getSaveStrategy() {
        return this.saveStrategy;
    }

    protected String escapeSpecialCharacters(String value) {
        value = value.replace("'", "&#39;");
        value = value.replace("\\", "&#92;");
        return value;
    }

    protected final void areNotNull(Object ... objects) {
        if (objects != null) {
            int index = 0;
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Assert.isNotNull((Object)object, (String)Messages.bind((String)Messages.RichTextWidget_Common_Nullable_Value_Error, (Object)(++index)));
                ++n2;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        MDERichTextWidget source = (MDERichTextWidget)evt.getSource();
        if (source != this && source.getElement() != null && source.getFeature() != null && source.getElement().equals(this.getElement()) && source.getFeature().equals(this.getFeature())) {
            String newValue = (String)evt.getNewValue();
            String currentText = this.getText();
            if (currentText != null && !currentText.equals(newValue)) {
                this.setText(newValue);
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        listenersSupports.addPropertyChangeListener(listener);
    }

    @Override
    public void dispose() {
        this.saveContent();
        PropertyChangeListener[] propertyChangeListeners = listenersSupports.getPropertyChangeListeners();
        if (propertyChangeListeners != null && propertyChangeListeners.length > 0) {
            PropertyChangeListener[] propertyChangeListenerArray = propertyChangeListeners;
            int n = propertyChangeListeners.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener propertyChangeListener = propertyChangeListenerArray[n2];
                listenersSupports.removePropertyChangeListener(propertyChangeListener);
                ++n2;
            }
        }
    }

    @Override
    public void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (event.getSource() == this) {
            listenersSupports.fire(event);
        }
    }

    @Override
    public void setIsLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }
}

