/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.project.VpDslProjectHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.NamedElement;

public class IconPathHelper {
    private static final String NO_ICON_NAME = "Icon name must have a value";
    private static final String VPELEMENT_IS_NULL = "Viewpoint element must be not null";
    private static final String VPELEMENT_NAME_IS_NULL = "Viewpoint element name must be not null";
    private static final String DEFAULT_ICON_FOLDER = "icons";
    private static final String DEFAULT_DESIGN_PROJECT = "design";
    private static final NullProgressMonitor NPM = new NullProgressMonitor();

    public static String computeDslIconPath(String iconName, NamedElement vpElement) {
        if (iconName == null || iconName.trim().length() == 0) {
            throw new IllegalArgumentException(NO_ICON_NAME);
        }
        if (vpElement == null) {
            throw new IllegalArgumentException(VPELEMENT_IS_NULL);
        }
        String pluginID = VpDslConfigurationHelper.getRootProjectName((Object)vpElement);
        return "/" + pluginID + "." + DEFAULT_DESIGN_PROJECT + "/" + DEFAULT_ICON_FOLDER + "/" + iconName;
    }

    public static boolean copyIconFile(String iconName, NamedElement vpElement) throws CoreException, InvocationTargetException, InterruptedException {
        boolean result = true;
        IFolder sourceFolder = VpDslProjectHelper.getVpDslIconFolder((EObject)vpElement, (boolean)false);
        if (sourceFolder == null || !sourceFolder.exists()) {
            return false;
        }
        final IFile sourceIcon = sourceFolder.getFile(iconName);
        if (sourceIcon == null || !sourceIcon.exists()) {
            return false;
        }
        IFolder targetFolder = IconPathHelper.getTargetFolder(vpElement);
        final IFile targetIcon = targetFolder.getFile(iconName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (targetIcon.exists()) {
                    targetIcon.delete(false, (IProgressMonitor)NPM);
                }
                sourceIcon.copy(targetIcon.getFullPath(), true, (IProgressMonitor)NPM);
            }
        };
        operation.run((IProgressMonitor)NPM);
        return result;
    }

    private static IFolder getTargetFolder(NamedElement vpElement) throws CoreException, InvocationTargetException, InterruptedException {
        String pluginID = VpDslConfigurationHelper.getRootProjectName((Object)vpElement);
        String designProjectPath = "/" + pluginID + "." + DEFAULT_DESIGN_PROJECT;
        IProject designProject = ResourcesPlugin.getWorkspace().getRoot().getProject(designProjectPath);
        final IFolder designIconFolder = designProject.getFolder(DEFAULT_ICON_FOLDER);
        if (!designIconFolder.exists()) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    designIconFolder.create(true, true, (IProgressMonitor)NPM);
                }
            };
            operation.run((IProgressMonitor)NPM);
        }
        return designIconFolder;
    }

    @Deprecated
    private static String computeTargetIconFileName(String iconName, NamedElement vpElement) {
        String vpElementName = vpElement.getName();
        String iconExt = IconPathHelper.getIconFileExtension(iconName);
        if (vpElementName.trim().length() == 0) {
            throw new IllegalArgumentException(VPELEMENT_NAME_IS_NULL);
        }
        return iconExt.trim().length() > 0 ? String.valueOf(vpElementName) + "." + iconExt : vpElementName;
    }

    private static String getIconFileExtension(String iconName) {
        int pointIndex = iconName.lastIndexOf(46);
        String iconExt = "";
        if (pointIndex != -1) {
            iconExt = iconName.substring(pointIndex + 1);
        }
        return iconExt;
    }
}

