/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import com.google.inject.Inject;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Attribute;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.data.DataSpec;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.data.Import;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.data.ImportURI;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.services.DataGrammarAccess;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.AbstractDataProposalProvider;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.NsUriFinder;

public class DataProposalProvider
extends AbstractDataProposalProvider {
    private static final String EMF_PLUGIN_ID = "org.eclipse.emf.ecore.edit";
    private static final String SCHEMAT_PATH = "icons/full/obj16/EPackage.gif";
    @Inject
    DataGrammarAccess grammar;
    @Inject
    IExternalContentSupport.IExternalContentProvider contentProvider;

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal proposal = this.createCompletionProposal(keyword.getValue(), this.getKeywordDisplayString(keyword), this.getImage((EObject)keyword), contentAssistContext);
        if (proposal == null) {
            return;
        }
        EObject current = contentAssistContext.getCurrentModel();
        if (current != null && NodeModelUtils.getNode((EObject)current) != null) {
            Data vp_Data;
            Attribute currentAtt;
            AbstractAttributeType type;
            ICompositeNode node = NodeModelUtils.getNode((EObject)current);
            EObject currentObject = NodeModelUtils.findActualSemanticObjectFor((INode)node);
            if (currentObject instanceof Attribute && (type = (currentAtt = (Attribute)currentObject).getOwned_type()) != null && type.getName() != null && type instanceof ExternalAttributeType && !type.getName().equals("EEnumerator") && proposal.getDisplayString().matches(this.grammar.getAttributeAccess().getValuesKeyword_6_0().getValue())) {
                return;
            }
            ICompositeNode rootNode = NodeModelUtils.getNode((EObject)current).getRootNode();
            EObject root = NodeModelUtils.findActualSemanticObjectFor((INode)rootNode);
            if (root != null && root instanceof Viewpoint && (vp_Data = ((Viewpoint)root).getVP_Data()) != null && proposal.getDisplayString().matches(this.grammar.getDataAccess().getDataKeyword_1().getValue())) {
                return;
            }
        }
        this.getPriorityHelper().adjustKeywordPriority(proposal, contentAssistContext.getPrefix());
        acceptor.accept(proposal);
    }

    @Override
    public void completeClass_Icon(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.complete_iconPath(model, assignment, context, acceptor);
    }

    private Collection<String> computeAlreadyImportedURI(EObject model) {
        if (!(model instanceof DataSpec)) {
            return Collections.emptyList();
        }
        HashSet<String> result = new HashSet<String>();
        DataSpec dataSpec = (DataSpec)model;
        EList imports = dataSpec.getImports();
        for (Import import1 : imports) {
            ImportURI importURI;
            String uri;
            if (!(import1 instanceof ImportURI) || (uri = (importURI = (ImportURI)import1).getImportURI()) == null || uri.isEmpty()) continue;
            result.add(uri);
        }
        return result;
    }

    @Override
    public void completeImportURI_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Bundle bundle = Platform.getBundle((String)EMF_PLUGIN_ID);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(SCHEMAT_PATH), (Map)Collections.EMPTY_MAP);
        Image image = ImageDescriptor.createFromURL((URL)url).createImage();
        Set<String> nsUris = NsUriFinder.getViewpointEPackagesNSURI(model, this.contentProvider);
        Collection<String> alreadyImported = this.computeAlreadyImportedURI(model.eContainer());
        for (String uri : nsUris) {
            if (uri.startsWith("\"")) {
                uri = uri.substring(1);
            }
            if (uri.endsWith("\"")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            if (alreadyImported.contains(uri)) continue;
            StyledString styledUri = URI.createURI((String)uri).isPlatformPlugin() ? new StyledString(uri, StyledString.COUNTER_STYLER) : new StyledString(uri, StyledString.DECORATIONS_STYLER);
            acceptor.accept(this.createCompletionProposal(this.createProposal(uri), styledUri, image, context));
        }
    }

    private String createProposal(String uri) {
        StringBuffer tmp = new StringBuffer();
        tmp.append("\"").append(uri).append("\"");
        return tmp.toString();
    }
}

