/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.services.cs.text.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.resource.XtextResource;
import org.polarsys.kitalpha.ad.af.dsl.services.cs.text.wizards.util.AfdslWizardsUtil;
import org.polarsys.kitalpha.ad.af.dsl.servicies.project.extension.IAFConcreteSyntaxResourceCreator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;

public class AfdslResourceCreator
implements IAFConcreteSyntaxResourceCreator {
    public static final String AFTEXT_EXTENSION = "aftext";
    private URI resourceURI;
    private String shortName;
    private String rootProjectName;
    private String dslProjectName;
    private String parentFolder;
    private String fileName;
    private List<Viewpoint> viewpoints = new ArrayList<Viewpoint>();

    public AfdslResourceCreator() {
    }

    public AfdslResourceCreator(String fileName, String shortName, String rootProjectName, String dslProjectName, List<Viewpoint> viewpoints) {
        this(shortName, rootProjectName, dslProjectName, viewpoints);
        this.fileName = fileName;
        this.parentFolder = null;
    }

    public AfdslResourceCreator(String shortName, String rootProjectName, String dslProjectName, List<Viewpoint> viewpoints) {
        this.shortName = shortName;
        this.rootProjectName = rootProjectName;
        this.dslProjectName = dslProjectName;
        this.viewpoints = viewpoints;
        this.parentFolder = null;
    }

    public boolean createConcreteSyntaxResource(String shortName, String rootProjectName, String dslProjectName, List<Viewpoint> viewpoints) {
        this.shortName = shortName;
        this.rootProjectName = rootProjectName;
        this.dslProjectName = dslProjectName;
        this.viewpoints = viewpoints;
        return this.createResourceAndOpenEditor();
    }

    public boolean createResourceAndOpenEditor() {
        this.doCreateResource();
        IFile file = this.getWorkspaceRoot().getFile((IPath)new Path(this.resourceURI.toPlatformString(true)));
        try {
            this.refreshWorkspace();
            if (file.exists()) {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            return true;
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean createResourceAndOpenEditor(IFile file) {
        String[] segments = file.getFullPath().segments();
        StringBuffer folders = new StringBuffer();
        int i = 1;
        while (i < segments.length - 1) {
            folders.append("/").append(segments[i]).append("/");
            ++i;
        }
        this.parentFolder = folders.toString();
        this.doCreateResource();
        try {
            this.refreshWorkspace();
            if (file.exists()) {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            return true;
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void doCreateResource() {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("AF Textual DSL Resource Creation", -1);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    URI uri = AfdslResourceCreator.this.computeURI();
                    AfdslResourceCreator.this.resourceURI = resourceSet.getURIConverter().normalize(uri);
                    XtextResource resource = (XtextResource)resourceSet.createResource(AfdslResourceCreator.this.resourceURI);
                    if (resource != null) {
                        try {
                            resource.reparse(AfdslResourceCreator.this.getInitialContent());
                            resource.save(Collections.emptyMap());
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    monitor.done();
                }
            }.run(AfdslResourceCreator.monitor());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String getSubFolders(String parentFolder) {
        if (parentFolder == null) {
            return "/model/";
        }
        return parentFolder;
    }

    private URI computeURI() {
        String aftextFileName = null;
        aftextFileName = this.fileName != null ? this.fileName.substring(0, this.fileName.indexOf(".")) : this.shortName;
        aftextFileName = aftextFileName.toLowerCase();
        String stringURI = String.valueOf('/') + this.dslProjectName + this.getSubFolders(this.parentFolder) + aftextFileName + "." + AFTEXT_EXTENSION;
        return AfdslWizardsUtil.URIFix.createPlatformResourceURI(stringURI, false);
    }

    protected String getInitialContent() {
        String header = "/**\n * Copyright (c) PolarSys, " + AfdslWizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tArchitecture Framework " + this.shortName + "\n" + " *\t@author: " + AfdslWizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + AfdslWizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "ArchitectureFramework " + this.shortName + " {\n" + "\tshortName: \"" + this.shortName + "\"" + "\n" + "\tViewpoints { \n";
        StringBuilder sB_Body = new StringBuilder();
        sB_Body.append("\t\t");
        int i = 0;
        while (i < this.viewpoints.size()) {
            sB_Body.append(this.viewpoints.get(i).getShortName());
            if (i < this.viewpoints.size() - 1) {
                sB_Body.append(", ");
            }
            ++i;
        }
        String footer = "\n\t}\n\tConfiguration {\n\t\trootProjectName: " + this.rootProjectName + "\n" + "\t}\n" + "}";
        String fileContent = String.valueOf(header) + sB_Body.toString() + footer;
        return fileContent;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void refreshWorkspace() {
        IProject project = this.getWorkspaceRoot().getProject(this.dslProjectName);
        try {
            project.refreshLocal(2, AfdslResourceCreator.monitor());
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    public static IProgressMonitor monitor() {
        return new NullProgressMonitor();
    }

    public StringBuffer createPluginXmlContribution(String shortName, String rootProjectName, String dslProjectName) {
        return null;
    }
}

