/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.core.util.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.PDEUtility;

public class GenerationPluginActivatorTask
implements ITaskProduction {
    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String pluginID = (String)productionContext.getInputValue((Object)"plugin.id", String.class);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginID);
        if (project.exists()) {
            ICompilationUnit activatorClass;
            IJavaProject javaProject;
            IPackageFragmentRoot srcFolder;
            IPackageFragment packageFragment;
            IFolder folder = project.getFolder("src");
            if (!folder.exists()) {
                try {
                    folder.create(true, true, null);
                }
                catch (CoreException e) {
                    throw new InvocationException("Can't create source folder", (Throwable)e);
                }
            }
            if (!(packageFragment = (srcFolder = (javaProject = JavaCore.create((IProject)project)).getPackageFragmentRoot((IResource)folder)).getPackageFragment(pluginID)).exists()) {
                try {
                    srcFolder.createPackageFragment(pluginID, true, monitor);
                }
                catch (JavaModelException e) {
                    throw new InvocationException("Can't create package " + pluginID, (Throwable)e);
                }
            }
            if (!(activatorClass = packageFragment.getCompilationUnit("Activator.java")).exists()) {
                try {
                    activatorClass = packageFragment.createCompilationUnit("Activator.java", GenerationPluginActivatorTask.activatorClassContent(pluginID), true, monitor);
                    PDEUtility.setActivator((IProject)project, (String)(String.valueOf(pluginID) + ".Activator"), (IProgressMonitor)monitor);
                    ArrayList<String> dependecies = new ArrayList<String>();
                    dependecies.add("org.eclipse.ui.workbench");
                    dependecies.add("org.eclipse.core.runtime");
                    PDEUtility.updateManifestModel((IProject)project, dependecies, null, (boolean)false, (IProgressMonitor)monitor);
                }
                catch (JavaModelException e) {
                    throw new InvocationException("Can't create Activator in package " + pluginID, (Throwable)e);
                }
            }
        } else {
            throw new RuntimeException("The plugin " + pluginID + " doesn't exixts");
        }
    }

    private static String activatorClassContent(String pluginID) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy 'at' hh:mm:ss z");
        String genTime = sdf.format(cal.getTime());
        return "// Generated on " + genTime + " by Viewpoint DSL Generator V 0.5.1 \n" + "package " + pluginID + ";\n" + "\n" + "import org.eclipse.ui.plugin.AbstractUIPlugin;\n" + "import org.osgi.framework.BundleContext;\n" + "\n" + "/**\n" + " * The activator class controls the plug-in life cycle\n" + " */\n" + "public class Activator extends AbstractUIPlugin {\n" + "\n" + "\t// The plug-in ID\n" + "\tpublic static final String PLUGIN_ID = \"" + pluginID + "\"; //$NON-NLS-1$\n" + "\n" + "\t// The shared instance\n" + "\tprivate static Activator plugin;\n" + "\t\n" + "\t/**\n" + "\t * The constructor\n" + "\t */\n" + "\tpublic Activator() {\n" + "\t}\n" + "\n" + "\t/*\n" + "\t * (non-Javadoc)\n" + "\t * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)\n" + "\t */\n" + "\tpublic void start(BundleContext context) throws Exception {\n" + "\t\tsuper.start(context);\n" + "\t\tplugin = this;\n" + "\t}\n" + "\n" + "\t/*\n" + "\t * (non-Javadoc)\n" + "\t * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)\n" + "\t */\n" + "\tpublic void stop(BundleContext context) throws Exception {\n" + "\t\tplugin = null;\n" + "\t\tsuper.stop(context);\n" + "\t}\n" + "\n" + "\t/**\n" + "\t * Returns the shared instance\n" + "\t *\n" + "\t * @return the shared instance\n" + "\t */\n" + "\tpublic static Activator getDefault() {\n" + "\t\treturn plugin;\n" + "\t}\n" + "\n" + "}";
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

