/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.api.path.variables;

import java.io.File;
import java.util.Set;
import org.polarsys.kitalpha.composer.Activator;
import org.polarsys.kitalpha.composer.api.path.variables.IComposerVariable;
import org.polarsys.kitalpha.composer.internal.path.variables.ComposerVariablesRegistry;

public class ComposerVariableInterpreter {
    private static final String DEB = "$";
    public static final ComposerVariableInterpreter INSTANCE = new ComposerVariableInterpreter();
    private static final String PARENT = "../";
    private ComposerVariablesRegistry registry = ComposerVariablesRegistry.INSTANCE;

    public Object execute(String value, Object obj) {
        String result = null;
        String path = value;
        IComposerVariable var = this.containsComposerVariables(path);
        if (var != null) {
            String substitution = var.execute(obj);
            String regex = DEB + var.getName();
            if (path.startsWith(PARENT)) {
                File f = new File(substitution);
                substitution = f.getParentFile().getAbsolutePath();
                regex = PARENT + regex;
            }
            result = path.replace(regex, substitution);
        } else {
            result = path;
        }
        return result;
    }

    private IComposerVariable containsComposerVariables(String path) {
        IComposerVariable var;
        block4: {
            var = null;
            try {
                if (path == null || path.equals("") || !path.contains(DEB)) break block4;
                String var_name = this.extract(path);
                if (var_name != null && !var_name.equals("")) {
                    var = this.registry.getVariable(var_name);
                    if (var == null) {
                        throw new Exception("The generation path use an invalid variable.");
                    }
                    break block4;
                }
                throw new Exception("The generation path use an invalid variable.");
            }
            catch (Exception e) {
                Activator.getDefault().error("Error while generating code", e);
            }
        }
        return var;
    }

    private String extract(String path) {
        String var = "";
        Set<String> keys = this.registry.getVariables();
        for (String key : keys) {
            if (!path.contains(key)) continue;
            var = key;
        }
        return var;
    }

    public void addNewVariable(IComposerVariable variable) {
        this.registry.addNewVariable(variable);
    }
}

