/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.ecore.helpers;

import java.util.Collection;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.domain.Activator;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.domain.Messages;
import org.eclipse.egf.domain.emf.EMFDomainHelper;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.domain.LoadableDomain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;

public class MDKDomainHelper
extends EMFDomainHelper {
    private ResourceSet resourceSet;

    private TransactionalEditingDomain getEditingDomain() {
        Session session = DiagramSessionHelper.getCurrentSession();
        if (session != null) {
            return session.getTransactionalEditingDomain();
        }
        return null;
    }

    protected boolean doLoadDomain(LoadableDomain domain) throws DomainException {
        if (domain instanceof EMFDomain) {
            EMFDomain myDomain = (EMFDomain)domain;
            myDomain.setLoaded(true);
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            this.resourceSet = editingDomain != null ? editingDomain.getResourceSet() : new TargetPlatformResourceSet();
            URI uri = myDomain.getUri();
            if (uri == null || "".equals(uri.toString())) {
                Activator.getDefault().logWarning(Messages.bind((String)Messages.Load_EMFDomain_error1, (Object)domain.getName()));
                return true;
            }
            Resource domainResource = null;
            try {
                domainResource = this.resourceSet.getResource(uri, true);
            }
            catch (Exception e) {
                throw new DomainException(Messages.bind((String)Messages.Load_EMFDomain_error2, (Object)uri.toString()), (Throwable)e);
            }
            if (!myDomain.getContent().isEmpty()) {
                throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
            }
            myDomain.getContent().addAll((Collection)domainResource.getContents());
            return true;
        }
        return false;
    }
}

