/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers.workspace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.RuleSet;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointFactory;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IRuleHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ResourceManager;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.WorkspaceManager;

public class RuleHandler
extends WorkspaceManager.ElementHandler
implements IRuleHandler {
    public RuleHandler(Viewpoint viewpoint, ResourceManager mgr) {
        super(viewpoint, mgr);
    }

    private RuleSet createRuleSet() {
        RuleSet ruleSet = ViewpointFactory.eINSTANCE.createRuleSet();
        ruleSet.setTarget(this.getViewpoint());
        ruleSet.setVpid(EcoreUtil.generateUUID());
        if (this.getWorkspace() != null) {
            this.getWorkspace().getRuleSets().add((Object)ruleSet);
        }
        return ruleSet;
    }

    @Override
    public void removeRules(List<Rule> rules) {
        for (Rule rule : rules) {
            if (!this.isRemovable((ViewpointElement)rule)) continue;
            EcoreUtil.delete((EObject)rule);
        }
        this.saveModel();
    }

    @Override
    public void createRule(String id) {
        this.createRule(id, null, null);
    }

    @Override
    public void createRule(String id, String type, String implementation) {
        if (this.getWorkspace() == null) {
            throw new IllegalStateException("no workspace available");
        }
        RuleSet set = this.getCurrentRuleSet();
        Rule rule = ViewpointFactory.eINSTANCE.createRule();
        rule.setId(id);
        rule.setType(type);
        rule.setImplementation(implementation);
        rule.setVpid(EcoreUtil.generateUUID());
        set.getNewRules().add((Object)rule);
        this.saveModel();
    }

    private RuleSet getCurrentRuleSet() {
        if (this.getWorkspace() == null) {
            return this.createRuleSet();
        }
        RuleSet set = this.getWorkspace().getRuleSet(this.getViewpoint());
        if (set == null) {
            set = this.createRuleSet();
        }
        return set;
    }

    @Override
    public List<ViewpointElement> getElements() {
        RuleSet set;
        EList toRemove = null;
        EList toAdd = null;
        HashMap<String, ViewpointElement> name2elt = new HashMap<String, ViewpointElement>();
        for (ViewpointElement elt : this.getViewpoint().getRules()) {
            name2elt.put(this.getIdentifier(elt), elt);
        }
        if (this.getWorkspace() != null && (set = this.getWorkspace().getRuleSet(this.getViewpoint())) != null) {
            toRemove = set.getHiddenRules();
            toAdd = set.getNewRules();
        }
        return this.computeElements((List<? extends ViewpointElement>)this.getViewpoint().getRules(), (List<? extends ViewpointElement>)toRemove, (List<? extends ViewpointElement>)toAdd);
    }

    @Override
    public List<ViewpointElement> getElementsFromParents() {
        HashMap<String, ViewpointElement> name2prop = new HashMap<String, ViewpointElement>();
        for (Viewpoint vp : this.getViewpoint().getAllParents()) {
            this.processViewpoint(vp, name2prop);
        }
        this.processViewpoint(this.getViewpoint(), name2prop);
        return new ArrayList<ViewpointElement>(name2prop.values());
    }

    private void processViewpoint(Viewpoint vp, Map<String, ViewpointElement> name2prop) {
        for (ViewpointElement elt : vp.getRules()) {
            name2prop.put(this.getIdentifier(elt), elt);
        }
    }
}

