/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.cs.text.ui.callback;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.builder.nature.NatureAddingEditorCallback;
import org.eclipse.xtext.builder.nature.ToggleXtextNatureAction;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;
import org.polarsys.kitalpha.ad.af.dsl.cs.text.ui.callback.Messages;
import org.polarsys.kitalpha.ad.af.dsl.services.cs.text.generators.Synchronizer;

public class AfdescEditorCallback
extends NatureAddingEditorCallback {
    protected XtextEditor currentEditor;
    @Inject
    private ToggleXtextNatureAction toggleNature;
    @Inject
    private DirtyStateEditorSupport editorSupport;
    @Inject
    private Injector injector;
    private boolean synchronizing = false;
    @Inject
    private IResourceSetProvider resourceSetProvider;

    public Injector getInjector() {
        return this.injector;
    }

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    public void afterCreatePartControl(XtextEditor editor) {
        if (this.currentEditor != editor) {
            throw new IllegalStateException(Messages.AfdescEditorCallback_MultipleInstancesError);
        }
        this.editorSupport.initializeDirtyStateSupport((DirtyStateEditorSupport.IDirtyStateEditorSupportClient)this.currentEditor);
        IResource resource = editor.getResource();
        if (resource != null && !this.toggleNature.hasNature(resource.getProject()) && resource.getProject().isAccessible() && !resource.getProject().isHidden()) {
            this.toggleNature.toggleNature(resource.getProject());
        }
    }

    public void beforeDispose(XtextEditor editor) {
        if (this.currentEditor != editor) {
            throw new IllegalStateException(Messages.AfdescEditorCallback_MultipleInstancesError);
        }
        this.editorSupport.removeDirtyStateSupport((DirtyStateEditorSupport.IDirtyStateEditorSupportClient)this.currentEditor);
        this.currentEditor = null;
    }

    public boolean onValidateEditorInputState(XtextEditor editor) {
        if (this.currentEditor != editor) {
            throw new IllegalStateException(Messages.AfdescEditorCallback_MultipleInstancesError);
        }
        return this.editorSupport.isEditingPossible((DirtyStateEditorSupport.IDirtyStateEditorSupportClient)this.currentEditor);
    }

    public void beforeSetInput(XtextEditor editor) {
        if (this.currentEditor != null) {
            this.editorSupport.removeDirtyStateSupport((DirtyStateEditorSupport.IDirtyStateEditorSupportClient)this.currentEditor);
        }
    }

    public void afterSetInput(XtextEditor editor) {
        if (this.currentEditor != null) {
            if (this.currentEditor != editor) {
                throw new IllegalStateException(Messages.AfdescEditorCallback_MultipleInstancesError);
            }
            this.editorSupport.initializeDirtyStateSupport((DirtyStateEditorSupport.IDirtyStateEditorSupportClient)this.currentEditor);
        } else {
            this.currentEditor = editor;
        }
    }

    public boolean isDirty() {
        return this.currentEditor.isDirty();
    }

    public IXtextDocument getDocument() {
        return this.currentEditor.getDocument();
    }

    public void addVerifyListener(VerifyListener listener) {
        ISourceViewer sourceViewer = this.currentEditor.getInternalSourceViewer();
        StyledText widget = sourceViewer.getTextWidget();
        widget.addVerifyListener(listener);
    }

    public Shell getShell() {
        return this.currentEditor.getEditorSite().getShell();
    }

    public void removeVerifyListener(VerifyListener listener) {
        ISourceViewer sourceViewer = this.currentEditor.getInternalSourceViewer();
        StyledText widget = sourceViewer.getTextWidget();
        if (widget != null) {
            widget.removeVerifyListener(listener);
        }
    }

    public void afterSave(XtextEditor editor) {
        if (this.currentEditor != editor) {
            throw new IllegalStateException(Messages.AfdescEditorCallback_MultipleInstancesError);
        }
        if (!this.synchronizing) {
            final XtextEditor current = editor;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!AfdescEditorCallback.this.synchronizing) {
                        AfdescEditorCallback.this.doSynchronize((IFile)current.getEditorInput().getAdapter(IFile.class));
                        AfdescEditorCallback.this.synchronizing = true;
                    }
                }
            };
            if (runnable != null) {
                this.update(runnable);
            }
        } else {
            this.synchronizing = false;
        }
        this.editorSupport.markEditorClean((DirtyStateEditorSupport.IDirtyStateEditorSupportClient)this.currentEditor);
    }

    protected boolean doSynchronize(IFile file) {
        Synchronizer synchronizer = new Synchronizer();
        return synchronizer.doSynchronize(file);
    }

    protected boolean validate(List<EObject> inputObjects) {
        for (EObject current : inputObjects) {
            if (this.validate(current)) continue;
            return false;
        }
        return true;
    }

    protected boolean validate(EObject object) {
        ArrayList diagnostics = new ArrayList();
        IConcreteSyntaxValidator concreteSyntaxValidator = ((XtextResource)object.eResource()).getConcreteSyntaxValidator();
        concreteSyntaxValidator.validateRecursive(object, (IConcreteSyntaxValidator.IDiagnosticAcceptor)new IConcreteSyntaxValidator.DiagnosticListAcceptor(diagnostics), new HashMap());
        return diagnostics.isEmpty();
    }

    public final IProject getProject(IFile file) {
        return file.getProject();
    }

    protected void update(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }
}

