/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.scrutiny.contrib.modelresources.scrutinize;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.share.modelresources.exceptions.ModelResourceException;
import org.polarsys.kitalpha.model.common.share.modelresources.helpers.DetachmentHelper;
import org.polarsys.kitalpha.model.common.share.modelresources.impl.ModelResource;
import org.polarsys.kitalpha.model.common.share.modelresources.impl.ModelResources;
import org.polarsys.kitalpha.model.common.share.modelresources.interfaces.IModelResource;
import org.polarsys.kitalpha.model.common.share.modelresources.interfaces.IModelResources;
import org.polarsys.kitalpha.model.common.share.modelresources.interfaces.ModelResourceState;

public class ModelResourcesScrutinizer
implements IScrutinize<IModelResources, String> {
    Logger LOGGER = Logger.getLogger(ModelResourcesScrutinizer.class);
    private final IModelResources modelResources = new ModelResources();

    public void findIn(EObject eObject) {
        URI eObjectURI = EcoreUtil.getURI((EObject)eObject);
        URI resourceURI = eObjectURI.trimFragment();
        try {
            IModelResource _modelResource = null;
            if (resourceURI != null && resourceURI.toString().isEmpty()) {
                resourceURI = DetachmentHelper.getPlatformResourceURIFromEObject((EObject)eObject);
            }
            if (!resourceURI.toString().startsWith("http://")) {
                _modelResource = this.modelResources.getModelResource(resourceURI);
            }
            if (eObject != null && eObject.eIsProxy()) {
                if (_modelResource == null) {
                    EcoreUtil.ExternalCrossReferencer.find((EObject)eObject);
                    _modelResource = ModelResource.newResource((URI)resourceURI, (ModelResourceState)ModelResourceState.UnknownResource);
                    this.getAnalysisResult().addResource(resourceURI, _modelResource);
                }
                _modelResource.addModelObject(eObject);
            } else {
                if (_modelResource == null) {
                    URI nsuri;
                    if (resourceURI.toString().startsWith("http://") && (resourceURI = DetachmentHelper.getPlatformURIFromNSURI((URI)(nsuri = eObject.eResource().getURI().trimFragment()))) == null) {
                        this.LOGGER.warn((Object)("Cannot find the resource which provides " + nsuri));
                        return;
                    }
                    EcoreUtil.ExternalCrossReferencer.find((EObject)eObject);
                    _modelResource = ModelResource.newResource((URI)resourceURI, (ModelResourceState)ModelResourceState.KnownResource);
                    this.getAnalysisResult().addResource(resourceURI, _modelResource);
                }
                _modelResource.addModelObject(eObject);
            }
        }
        catch (ModelResourceException e) {
            this.LOGGER.warn((Object)e.getMessage());
        }
    }

    public void findIn(Resource resource) {
    }

    public IModelResources getAnalysisResult() {
        return this.modelResources;
    }

    public String getFeedbackAnalysisMessages() {
        return null;
    }
}

