/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.ta.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.kitalpha.ad.ta.extension.ITargetApplication;
import org.polarsys.kitalpha.ad.ta.message.Messages;

public class TargetApplicationExtensionManager {
    public static String getRootProjectName(String targetApplicationName) {
        IConfigurationElement element = TargetApplicationExtensionManager.getTargetApplicationExtension(targetApplicationName);
        return element.getAttribute("RootProjectName");
    }

    public static String getRootNsUri(String targetApplicationName) {
        IConfigurationElement element = TargetApplicationExtensionManager.getTargetApplicationExtension(targetApplicationName);
        return element.getAttribute("RootNsURI");
    }

    public static String getDescription(String targetApplicationName) {
        IConfigurationElement element = TargetApplicationExtensionManager.getTargetApplicationExtension(targetApplicationName);
        return element.getAttribute("description");
    }

    public static Map<String, List<String>> getTargetApplicationMetaModels(String targetApplicationName) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        IConfigurationElement element = TargetApplicationExtensionManager.getTargetApplicationExtension(targetApplicationName);
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (configurationElement.getName().equals("metaModel")) {
                String nsuri = configurationElement.getAttribute("nsuri");
                String type = configurationElement.getAttribute("type");
                ArrayList<String> list = (ArrayList<String>)result.get(type);
                if (list == null) {
                    list = new ArrayList<String>();
                    result.put(type, list);
                }
                list.add(nsuri);
            }
            ++n2;
        }
        return result;
    }

    public static ITargetApplication getTargetApplicationClass(String targetApplicationName) throws CoreException {
        IConfigurationElement element = TargetApplicationExtensionManager.getTargetApplicationExtension(targetApplicationName);
        return (ITargetApplication)element.createExecutableExtension("class");
    }

    public static String[] getSupportedTargetApplication() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.ad.ta.definition");
        Object[] result = new String[]{};
        if (config.length != 0) {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getName().equals("definition")) {
                    String mEnvironment = iConfigurationElement.getAttribute("name");
                    String[] temp = new String[result.length + 1];
                    System.arraycopy(result, 0, temp, 0, result.length);
                    temp[result.length] = mEnvironment;
                    result = new String[temp.length];
                    System.arraycopy(temp, 0, result, 0, temp.length);
                }
                ++n2;
            }
        }
        Arrays.sort(result);
        return result;
    }

    public static IConfigurationElement getTargetApplicationExtension(String targetApplicationName) {
        IConfigurationElement[] config;
        if (targetApplicationName == null || targetApplicationName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.Target_Application__NameNotValid);
        }
        if (targetApplicationName.trim().length() > 0 && (config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.ad.ta.definition")).length != 0) {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                String mEnvironment;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getName().equals("definition") && (mEnvironment = iConfigurationElement.getAttribute("name")).equals(targetApplicationName)) {
                    return iConfigurationElement;
                }
                ++n2;
            }
        }
        String msg = Messages.bind((String)Messages.Target_Application__Unknown, (Object)targetApplicationName);
        throw new RuntimeException(msg);
    }
}

