/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.contrib.unknownreference.metadata;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.kitalpha.ad.metadata.metadata.ViewpointReference;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;
import org.polarsys.kitalpha.model.common.contrib.unknownreference.metadata.MetadataUnknownReferencedViewpoint;
import org.polarsys.kitalpha.model.common.contrib.unknownreference.metadata.internal.Activator;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;

public class MetaDataCleanerCommand
extends ModelCommand {
    public void exec(ModelScrutinyRegistry analysis, Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((ResourceSet)resource.getResourceSet());
        try {
            ModelScrutinyRegistry.RegistryElement regElt = analysis.getRegistryElement(this.getModelAnalysisID());
            monitor.beginTask("Clean Metadata", 1);
            for (IScrutinize finder : regElt.getFinders()) {
                if (!(finder instanceof MetadataUnknownReferencedViewpoint)) continue;
                monitor.subTask("Clean Uninstalled Viewpoint from Metadata");
                MetadataUnknownReferencedViewpoint uninstalledViewpoints = (MetadataUnknownReferencedViewpoint)finder;
                Iterator iterator = uninstalledViewpoints.getAnalysisResult().iterator();
                while (iterator.hasNext()) {
                    ViewpointReference vr = (ViewpointReference)iterator.next();
                    if (ed != null) {
                        Command remove = RemoveCommand.create((EditingDomain)ed, (Object)vr);
                        if (!remove.canExecute()) continue;
                        ed.getCommandStack().execute(remove);
                        continue;
                    }
                    EcoreUtil.remove((EObject)vr);
                }
            }
        }
        catch (ModelScrutinyException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.model.common.contrib.unknownreference.metadata", e.getMessage(), (Throwable)e));
        }
        monitor.worked(1);
        monitor.done();
    }
}

