/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.polarsys.kitalpha.cadence.core.api.CadenceRegistry;

public class CadenceListSelectionDialog
extends SelectionDialog {
    private Object inputElement;
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    CheckboxTableViewer listViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    protected Label description = null;
    protected int descriptionHeight = 40;
    static String SELECT_ALL_TITLE = "&Select All";
    static String DESELECT_ALL_TITLE = "&Deselect All";

    public CadenceListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
        super(parentShell);
        this.setTitle("Selection Needed");
        this.inputElement = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage("Select the items:");
        }
    }

    private void addDescritionArea(Composite composite) {
        this.description = new Label(composite, 2048);
        GridData gd = new GridData();
        gd.heightHint = this.descriptionHeight;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = false;
        this.description.setLayoutData((Object)gd);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selected = selection.getFirstElement();
                if (selected instanceof IConfigurationElement) {
                    IConfigurationElement conf = (IConfigurationElement)selected;
                    String desc = CadenceRegistry.getDescription((IConfigurationElement)conf);
                    CadenceListSelectionDialog.this.description.setText(desc);
                }
            }
        });
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CadenceListSelectionDialog.this.listViewer.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CadenceListSelectionDialog.this.listViewer.setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.addSelectionButtons(composite);
        this.addDescritionArea(composite);
        this.initializeViewer();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Label getDescription() {
        return this.description;
    }

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            this.setResult(list);
        }
        super.okPressed();
    }
}

