/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.description.SystemColor;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.sirius.viewpoint.description.SytemColorsPalette;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.javaservice.JavaServiceData;

public class GenerationUtil {
    private static Map<EObject, EObject> generationObjectsMap = new HashMap<EObject, EObject>();
    private static List<JavaServiceData> javaServiceToGenerate = new ArrayList<JavaServiceData>();
    private static SytemColorsPalette systemColorsPalette = null;

    public static void clear() {
        generationObjectsMap.clear();
        javaServiceToGenerate.clear();
        systemColorsPalette = null;
    }

    public static void setSytemColorsPalette(SytemColorsPalette sysColorsPalette) {
        systemColorsPalette = sysColorsPalette;
    }

    public static SytemColorsPalette getSytemColorsPalette() {
        return systemColorsPalette;
    }

    public static SystemColor getSystemColor(SystemColors color) {
        for (SystemColor iSystemColor : systemColorsPalette.getEntries()) {
            if (!iSystemColor.getName().equals(color.getName())) continue;
            return iSystemColor;
        }
        return null;
    }

    public static void addObjectMapping(EObject vpElement, EObject doremiElement) {
        if (vpElement != null) {
            // empty if block
        }
        if (!generationObjectsMap.containsKey(vpElement)) {
            generationObjectsMap.put(vpElement, doremiElement);
        }
    }

    public static EObject getDoremiElement(EObject vpElement) {
        return generationObjectsMap.get(vpElement);
    }

    public static JavaServiceData getJavaServiceDataFor(EObject eObject) {
        for (JavaServiceData iJavaServiceData : javaServiceToGenerate) {
            if (!iJavaServiceData.getContext().equals(eObject)) continue;
            return iJavaServiceData;
        }
        return null;
    }

    public static List<JavaServiceData> getAllJavaServiceData() {
        return javaServiceToGenerate;
    }

    public static JavaServiceData getJavaServiceData(String name) {
        String[] nameElement = name.split("\\.");
        String className = nameElement[nameElement.length - 1];
        StringBuilder builder = new StringBuilder();
        builder.append(nameElement[0]);
        int i = 1;
        while (i < nameElement.length - 1) {
            builder.append(".").append(nameElement[i]);
            ++i;
        }
        String packageName = builder.toString();
        for (JavaServiceData iJavaServiceData : javaServiceToGenerate) {
            if (!iJavaServiceData.getPackageName().equalsIgnoreCase(packageName) || !iJavaServiceData.getClassName().equalsIgnoreCase(className)) continue;
            return iJavaServiceData;
        }
        JavaServiceData javaService = new JavaServiceData(packageName, className);
        GenerationUtil.addJavaService(javaService);
        return javaService;
    }

    protected static void addJavaService(JavaServiceData javaService) {
        boolean addJavaService = true;
        for (JavaServiceData iJavaServiceData : javaServiceToGenerate) {
            if (!iJavaServiceData.equals(javaService)) continue;
            addJavaService = false;
        }
        if (addJavaService) {
            javaServiceToGenerate.add(javaService);
        }
    }
}

