/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.diagram.javaaction;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.polarsys.kitalpha.emde.diagram.javaaction.AbstractEmdeExternalJavaAction;
import org.polarsys.kitalpha.emde.diagram.services.ExtensibilityService;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class RemoveExtensibilityAction
extends AbstractEmdeExternalJavaAction {
    private static final String ELEMENT = "element";
    private static final String VIEW = "view";

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EClass element = (EClass)parameters.get(ELEMENT);
        EClass superType = null;
        if (ExtensibilityService.isInstanceOf(element, EmdePackage.Literals.ELEMENT_EXTENSION)) {
            superType = ExtensibilityService.convert(EmdePackage.Literals.ELEMENT_EXTENSION);
        }
        if (superType != null) {
            EList superTypes = element.getESuperTypes();
            for (EClass eClass : superTypes) {
                if (!EcoreUtil.equals((EObject)eClass, (EObject)superType)) continue;
                superType = eClass;
                break;
            }
            element.getESuperTypes().remove((Object)superType);
            EAnnotation annotation1 = ExtensibilityService.getAnnotation(element, "http://www.polarsys.org/kitalpha/emde/1.0.0/constraint");
            EAnnotation annotation2 = ExtensibilityService.getAnnotation(element, "http://www.polarsys.org/kitalpha/emde/1.0.0/constraintMapping");
            UniqueEList objects = new UniqueEList();
            for (Map.Entry entry : annotation2.getDetails()) {
                if (!(entry instanceof EStringToStringMapEntryImpl)) continue;
                objects.addAll(ExtensibilityService.getExtendedModel((EStringToStringMapEntryImpl)entry));
            }
            if (annotation1 != null) {
                element.getEAnnotations().remove((Object)annotation1);
            }
            if (annotation2 != null) {
                element.getEAnnotations().remove((Object)annotation2);
            }
            DDiagramElement view = (DDiagramElement)parameters.get(VIEW);
            ExtensibilityService.clean((EObject)view, (Collection<EObject>)objects);
        }
    }
}

