/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.builder;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IResourceUIServiceProvider;
import org.eclipse.xtext.ui.resource.IResourceUIServiceProviderExtension;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;

public class PeriodicURIValidator
extends UriValidator {
    @Inject
    private IResourceServiceProvider.Registry registry;

    public boolean isValid(URI uri, IStorage storage) {
        if (uri == null) {
            return false;
        }
        IResourceServiceProvider resourceServiceProvider = this.getResourceServiceProvider(uri);
        if (resourceServiceProvider != null) {
            if (resourceServiceProvider instanceof IResourceUIServiceProvider) {
                return ((IResourceUIServiceProvider)resourceServiceProvider).canHandle(uri, storage);
            }
            return resourceServiceProvider.canHandle(uri);
        }
        return false;
    }

    public boolean canBuild(URI uri, IStorage storage) {
        if (uri == null) {
            return false;
        }
        IResourceServiceProvider resourceServiceProvider = this.getResourceServiceProvider(uri);
        if (resourceServiceProvider != null) {
            if (resourceServiceProvider instanceof IResourceUIServiceProviderExtension) {
                return ((IResourceUIServiceProviderExtension)resourceServiceProvider).canBuild(uri, storage);
            }
            if (resourceServiceProvider instanceof IResourceUIServiceProvider) {
                return ((IResourceUIServiceProvider)resourceServiceProvider).canHandle(uri, storage);
            }
            return resourceServiceProvider.canHandle(uri);
        }
        return false;
    }

    private IResourceServiceProvider getResourceServiceProvider(URI uri) {
        if (ResourceHelper.hasPeriodicFileExtension((URI)uri)) {
            Map extensionToFactoryMap = this.registry.getExtensionToFactoryMap();
            return ResourceHelper.getServiceProvider((URI)uri, (Map)extensionToFactoryMap, (String)ResourceHelper.getFileExtension((URI)uri));
        }
        return this.registry.getResourceServiceProvider(uri);
    }

    public boolean isPossiblyManaged(IStorage storage) {
        if (!this.registry.getContentTypeToFactoryMap().isEmpty()) {
            return true;
        }
        String name = storage.getName();
        if (name == null) {
            return true;
        }
        int index = (name = URI.encodeSegment((String)name, (boolean)true)).indexOf(46);
        if (index == -1) {
            return true;
        }
        return this.registry.getExtensionToFactoryMap().containsKey(name.substring(index + 1));
    }
}

