/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ecore.diagram.eclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.kitalpha.ecore.diagram.service.EcoreService;

public class EClassService {
    private static final int MAX_DEPTH = 1;
    private static EcoreService ecoreServicePlus = new EcoreService();

    public Collection<EClass> focusEFImportEClassSCE(EClass root, Set<EReference> eTypeInverse, Set<EReference> allSuperTypeETypeInverse) {
        UniqueEList result = new UniqueEList();
        result.addAll((Collection)root.getEAllSuperTypes());
        EList eAllReferences = root.getEAllReferences();
        for (EReference eReference : eAllReferences) {
            result.add((Object)((EClass)eReference.eContainer()));
        }
        if (eTypeInverse != null && !eTypeInverse.isEmpty()) {
            for (EReference eReference : eTypeInverse) {
                result.add((Object)((EClass)eReference.eContainer()));
            }
        }
        if (allSuperTypeETypeInverse != null && !allSuperTypeETypeInverse.isEmpty()) {
            for (EReference eReference : allSuperTypeETypeInverse) {
                result.add((Object)((EClass)eReference.eContainer()));
            }
        }
        return result;
    }

    public String getEOperationLabel(EOperation eOperation) {
        String result = "";
        if (eOperation != null) {
            String name = eOperation.getName();
            result = name != null && !name.isEmpty() ? name : "<<No name>>";
            EClassifier eType = eOperation.getEType();
            if (eType != null) {
                result = String.valueOf(result) + " : " + eType.getName();
            }
        }
        return result;
    }

    public boolean linksPrecondition(EReference reference, Boolean containment, Boolean autoReference) {
        EClass eContainer = (EClass)reference.eContainer();
        boolean result = true;
        result &= autoReference != false ? eContainer.equals(reference.getEType()) : !eContainer.equals(reference.getEType());
        return result &= containment != false ? reference.isContainment() : !reference.isContainment();
    }

    public Collection<EClass> getFocusNeighbourgClassesSemanticCandidate(EClass root, Set<EObject> referencing) {
        UniqueEList result = new UniqueEList();
        result.addAll((Collection)root.getESuperTypes());
        for (EReference eReference : root.getEReferences()) {
            result.add((Object)((EClass)eReference.getEType()));
        }
        for (EObject reference_o : referencing) {
            result.add((Object)((EClass)reference_o.eContainer()));
        }
        result.remove((Object)root);
        return result;
    }

    public Collection<EClass> getNeighbourgClassesSemanticCandidate(EClass root, Set<EObject> referencing, Boolean containment) {
        UniqueEList result = new UniqueEList();
        EList eAllReferences = root.getEAllReferences();
        for (EReference eReference : eAllReferences) {
            if (eReference.isContainment() != containment.booleanValue()) continue;
            result.add((Object)((EClass)eReference.getEType()));
        }
        for (EObject eObject : referencing) {
            if (!(eObject instanceof EReference) || eObject.eContainer() == root || ((EReference)eObject).isContainment() != containment.booleanValue()) continue;
            result.add((Object)((EClass)eObject.eContainer()));
        }
        return result;
    }

    public Collection<EClass> getNeighbourgClasses(EClass root) {
        EList eAllSuperTypes = root.getEAllSuperTypes();
        Collection<EClass> descendants = this.getDescendants(root);
        UniqueEList result = new UniqueEList();
        result.addAll((Collection)eAllSuperTypes);
        result.addAll(descendants);
        return result;
    }

    public Collection<EClass> getDescendants(EClass root) {
        return this.getDescendants(root, 1);
    }

    public Collection<EClass> getDescendants(EClass root, int depth) {
        if (depth > 0) {
            Session session = SessionManager.INSTANCE.getSession((EObject)root);
            ECrossReferenceAdapter eCrossReferenceAdapter = session.getSemanticCrossReferencer();
            Collection<EClass> local = ecoreServicePlus.getDirectDescendants(root, eCrossReferenceAdapter);
            if (local.size() > 0) {
                UniqueEList result = new UniqueEList();
                result.addAll(local);
                for (EClass e : local) {
                    result.addAll(this.getDescendants(e, depth - 1));
                }
                return result;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public Collection<EClass> getAllEClass(EPackage root) {
        UniqueEList result = new UniqueEList();
        if (root != null) {
            Resource r = root.eResource();
            ResourceSet bigRS = r.getResourceSet();
            if (r != null) {
                ResourceSetImpl rs = new ResourceSetImpl();
                rs.setPackageRegistry(bigRS.getPackageRegistry());
                rs.setResourceFactoryRegistry(bigRS.getResourceFactoryRegistry());
                rs.getResource(r.getURI(), true);
                EcoreUtil.resolveAll((ResourceSet)rs);
                Collection<URI> uriList = this.getURIList((ResourceSet)rs);
                for (URI uri : uriList) {
                    EPackage ePackage;
                    Resource internalResource = EClassService.getResource(bigRS, uri);
                    if (internalResource == null || (ePackage = (EPackage)internalResource.getContents().get(0)) == null) continue;
                    TreeIterator iterator = ePackage.eAllContents();
                    while (iterator.hasNext()) {
                        EObject next = (EObject)iterator.next();
                        if (!(next instanceof EClass)) continue;
                        result.add((EClass)next);
                    }
                }
            }
        }
        return result;
    }

    private static Resource getResource(ResourceSet rs, URI uri) {
        for (Resource r : rs.getResources()) {
            if (!r.getURI().equals(uri)) continue;
            return r;
        }
        return null;
    }

    private Collection<URI> getURIList(ResourceSet rs) {
        ArrayList<URI> result = new ArrayList<URI>();
        for (Resource resource : rs.getResources()) {
            URI uri = resource.getURI();
            if (!uri.toString().contains("ecore") || resource.getContents() == null || resource.getContents().size() <= 0) continue;
            result.add(uri);
        }
        return result;
    }
}

