/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpservices;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PropertyType implements Enumerator
{
    INTEGER(0, "Integer", "Integer_Literal"),
    STRING(1, "String", "String_Literal"),
    BOOLEAN(2, "Boolean", "Boolean_Literal"),
    FLOAT(3, "Float", "Float_Literal");

    public static final int INTEGER_VALUE = 0;
    public static final int STRING_VALUE = 1;
    public static final int BOOLEAN_VALUE = 2;
    public static final int FLOAT_VALUE = 3;
    private static final PropertyType[] VALUES_ARRAY;
    public static final List<PropertyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PropertyType[]{INTEGER, STRING, BOOLEAN, FLOAT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PropertyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyType get(int value) {
        switch (value) {
            case 0: {
                return INTEGER;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return BOOLEAN;
            }
            case 3: {
                return FLOAT;
            }
        }
        return null;
    }

    private PropertyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

