/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.common.util.MDERichTextHelper;
import org.polarsys.kitalpha.richtext.widget.editor.MDERichTextEditorInput;
import org.polarsys.kitalpha.richtext.widget.editor.intf.MDERichTextEditorCallback;
import org.polarsys.kitalpha.richtext.widget.factory.MDERichTextFactory;
import org.polarsys.kitalpha.richtext.widget.internal.Activator;
import org.polarsys.kitalpha.richtext.widget.internal.RichtextEditorResourceSetListener;
import org.polarsys.kitalpha.richtext.widget.internal.extension.MDERichTextExtensionManager;

public class MDERichTextEditor
extends EditorPart
implements ITabbedPropertySheetPageContributor,
PropertyChangeListener {
    public static final String SAVE_CALLBACK_EXTENSION_ID = "org.polarsys.kitalpha.richtext.widget.saveResourceCallback";
    public static final String SAVE_CALLBACK_CLASS_ATTR = "class";
    private static final RichtextEditorResourceSetListener closeEditorResourceSetListener = new RichtextEditorResourceSetListener();
    private MDERichTextWidget widget;
    private boolean activateState = false;
    private final MDERichTextExtensionManager propertySheetExtensionManager = new MDERichTextExtensionManager(this);
    private TabbedPropertySheetPage propertySheetPage;
    private final IWorkbenchListener closeListener = new IWorkbenchListener(){

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            activePage.closeEditor((IEditorPart)MDERichTextEditor.this, true);
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
        }
    };
    private final IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                MDERichTextEditor.this.processDelta(delta);
            }
        }
    };

    public MDERichTextEditor() {
        PlatformUI.getWorkbench().addWorkbenchListener(this.closeListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    private void processDelta(IResourceDelta delta) {
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(2);
        IEditorInput editorInput = this.getEditorInput();
        MDERichTextEditorInput input = (MDERichTextEditorInput)editorInput;
        EObject element = input.getElement();
        Resource eResource = element.eResource();
        if (eResource != null) {
            IFile file = MDERichTextHelper.getFile((EObject)element);
            String fileString = file.getFullPath().toString();
            this.processResourceDelta(affectedChildren, fileString);
        } else {
            Status status = new Status(2, "org.polarsys.kitalpha.richtext.widget", "Could nof find the resource of the editor: " + editorInput.getName());
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void processResourceDelta(IResourceDelta[] affectedChildren, String deletedFilePath) {
        IResourceDelta[] iResourceDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                String path = resource.getFullPath().toString();
                if (deletedFilePath.equals(path)) {
                    this.closeEditor();
                }
            } else {
                this.processResourceDelta(delta.getAffectedChildren(2), deletedFilePath);
            }
            ++n2;
        }
    }

    private void closeEditor() {
        this.switchDeactivateState();
        Display.getDefault().asyncExec(() -> {
            boolean bl = this.getSite().getPage().closeEditor((IEditorPart)this, false);
        });
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isDeactivate()) {
            this.widget.saveContent();
            this.doSaveCallback(this.widget);
            this.firePropertyChange(257);
            this.firePropertyChange(1);
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setMDERichTextEditorPartName();
        this.registerResourceSetListener(input);
        this.getEditorSite().setSelectionProvider(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                EObject modelElement = MDERichTextEditor.this.widget.getElement();
                return modelElement != null ? new StructuredSelection((Object)modelElement) : StructuredSelection.EMPTY;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
    }

    private void registerResourceSetListener(IEditorInput input) {
        MDERichTextEditorInput richTextInput = (MDERichTextEditorInput)input;
        EObject element = richTextInput.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)element);
        if (editingDomain != null) {
            editingDomain.addResourceSetListener((ResourceSetListener)closeEditorResourceSetListener);
        }
    }

    public void setMDERichTextEditorPartName() {
        String title = this.getEditorInput().getName();
        this.setPartName(title);
    }

    public boolean isDirty() {
        if (!this.isDeactivate()) {
            return this.doCheckWorkspaceResourceStatus(this.widget) || this.widget.isDirty();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.widget = new MDERichTextFactory().createEditorRichTextWidget(parent);
        this.widget.addPropertyChangeListener((PropertyChangeListener)this);
        MDERichTextEditorInput input = (MDERichTextEditorInput)this.getEditorInput();
        this.widget.setSaveStrategy(input.getSaveStrategy());
        this.widget.bind(input.getElement(), input.getFeature());
    }

    public void setFocus() {
        if (!this.isDeactivate()) {
            this.widget.setFocus();
            this.widget.loadContent();
        }
    }

    public void dispose() {
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
            this.propertySheetPage = null;
        }
        super.dispose();
        this.unregisterResourceSetListener();
        this.widget.dispose();
        PlatformUI.getWorkbench().removeWorkbenchListener(this.closeListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
    }

    private void unregisterResourceSetListener() {
        boolean disposeResourceSetListener = true;
        EObject element = this.widget.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)element);
        IWorkbenchPage page = this.getSite().getPage();
        long nbOpenedEditors = Arrays.stream(page.getEditorReferences()).filter(e -> "org.polarsys.kitalpha.richtext.widget.editor".equals(e.getId()) && this.isInSameEditingDomain(editingDomain, (IEditorReference)e)).count();
        boolean bl = disposeResourceSetListener = nbOpenedEditors == 0L;
        if (editingDomain != null && disposeResourceSetListener) {
            editingDomain.removeResourceSetListener((ResourceSetListener)closeEditorResourceSetListener);
        }
    }

    private boolean isInSameEditingDomain(TransactionalEditingDomain editingDomain, IEditorReference eReference) {
        try {
            MDERichTextEditorInput editorInput = (MDERichTextEditorInput)eReference.getEditorInput();
            TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)editorInput.getElement());
            return ed == editingDomain;
        }
        catch (PartInitException e) {
            Status status = new Status(2, "org.polarsys.kitalpha.richtext.widget", "Cannot Retrieve The Editor Input", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    public String getContributorId() {
        return this.propertySheetExtensionManager.getContributorId();
    }

    public TabbedPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = this.propertySheetExtensionManager.getDelegate();
        }
        return this.propertySheetPage;
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public void switchDeactivateState() {
        this.activateState = !this.activateState;
    }

    public boolean isDeactivate() {
        return this.activateState;
    }

    private void doSaveCallback(MDERichTextWidget widget) {
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(SAVE_CALLBACK_EXTENSION_ID);
        if (contributions != null && contributions.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                try {
                    MDERichTextEditorCallback callback = (MDERichTextEditorCallback)c.createExecutableExtension(SAVE_CALLBACK_CLASS_ATTR);
                    callback.saveWorkspaceResource(widget);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                ++n2;
            }
        }
    }

    private boolean doCheckWorkspaceResourceStatus(MDERichTextWidget widget) {
        boolean result = true;
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(SAVE_CALLBACK_EXTENSION_ID);
        if (contributions != null && contributions.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                try {
                    MDERichTextEditorCallback callback = (MDERichTextEditorCallback)c.createExecutableExtension(SAVE_CALLBACK_CLASS_ATTR);
                    result &= callback.isWorkspaceResourceDirty(widget);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        MDERichTextWidget source = (MDERichTextWidget)evt.getSource();
        if (this.widget == source && evt.getPropertyName().equals("widgetSaved") || evt.getPropertyName().equals("dirtyStateUpdated")) {
            this.firePropertyChange(257);
            this.firePropertyChange(1);
        }
    }
}

