/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.polarsys.kitalpha.ad.ta.extension.ITargetApplication;
import org.polarsys.kitalpha.ad.ta.extension.TargetApplicationExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.utils.EcoreElementsUtil;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class ReverseUtil {
    public static URI getDomainURI(IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj instanceof IResource) {
            IFile vpSpecFile = null;
            if (obj instanceof IFile) {
                vpSpecFile = (IFile)obj;
            }
            if (vpSpecFile != null && vpSpecFile.exists()) {
                return URI.createPlatformResourceURI((String)vpSpecFile.getFullPath().toString(), (boolean)true);
            }
        }
        return null;
    }

    public static List<EPackage> getEPackagesByNsUri(List<String> nsUris) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (String nsUri : nsUris) {
            EPackage ePackage = EPackageRegistryImpl.INSTANCE.getEPackage(nsUri);
            if (ePackage == null) continue;
            result.add(ePackage);
        }
        return result;
    }

    public static List<EPackage> getEPackagesByNsUriRegex(List<String> nsUris) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        Set entrySet = EPackageRegistryImpl.INSTANCE.entrySet();
        for (Map.Entry entry : entrySet) {
            String registryNsUri = (String)entry.getKey();
            for (String nsUriRegex : nsUris) {
                Pattern pattern = Pattern.compile(nsUriRegex);
                Matcher matcher = pattern.matcher(registryNsUri);
                if (!matcher.matches()) continue;
                EPackage ePackage = null;
                if (entry.getValue() instanceof EPackage) {
                    ePackage = (EPackage)entry.getValue();
                } else {
                    EPackage.Descriptor descriptor = (EPackage.Descriptor)entry.getValue();
                    ePackage = descriptor.getEPackage();
                }
                if (ePackage == null) continue;
                result.add(ePackage);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGeneratedInheritance(Class vpClass, EClass superClass, Resource resource) {
        if (EcoreElementsUtil.areEClassesTheSame(superClass, EmdePackage.eINSTANCE.getElementExtension(), resource)) {
            return true;
        }
        try {
            EClass defaultInheritance;
            Viewpoint viewpoint = (Viewpoint)EcoreUtil.getRootContainer((EObject)vpClass, (boolean)true);
            String taName = VpDslConfigurationHelper.getTargetApplication((Object)viewpoint);
            ITargetApplication targetApplication = TargetApplicationExtensionManager.getTargetApplicationClass((String)taName);
            List defaultInheritanceList = targetApplication.getBasicSemanticElement();
            if (defaultInheritanceList == null) return false;
            if (defaultInheritanceList.size() <= 0) return false;
            Iterator iterator = defaultInheritanceList.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!EcoreElementsUtil.areEClassesTheSame(superClass, defaultInheritance = (EClass)iterator.next(), resource));
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }
}

