/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.predicate.internal.extension.manager;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Predicate;
import org.polarsys.kitalpha.ad.viewpoint.predicate.internal.Activator;
import org.polarsys.kitalpha.ad.viewpoint.predicate.internal.extension.manager.AbstractExtensionManager;

public class PredicateExtensionManager
extends AbstractExtensionManager {
    private static final PredicateExtensionManager INSTANCE = new PredicateExtensionManager();

    public static synchronized PredicateExtensionManager getInstance() {
        return INSTANCE;
    }

    public String getDiagnosticMessageForPredicate(IConfigurationElement e) {
        IConfigurationElement[] children = e.getChildren();
        if (children != null && children.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                if (c.getName().equals("Message")) {
                    return c.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public IConfigurationElement retrivePredicateConfigurationElement(String id) throws CoreException {
        IConfigurationElement[] predicateExtensions = (IConfigurationElement[])this.getExtensionFor.apply("org.polarsys.kitalpha.ad.viewpoint.predicate.declaration");
        Stream<IConfigurationElement> stream = Arrays.stream(predicateExtensions);
        List predicates = stream.filter(e -> e.getAttribute("ID").equals(id)).collect(Collectors.toList());
        if (predicates.size() == 1) {
            return (IConfigurationElement)predicates.get(0);
        }
        if (predicates.size() > 1) {
            Status status = new Status(2, "org.polarsys.kitalpha.ad.viewpoint.predicate", "More than one contribution found for the id: " + id + ". Only the first is taken in account");
            Activator.getDefault().getLog().log((IStatus)status);
            return (IConfigurationElement)predicates.get(0);
        }
        Status status = new Status(4, "org.polarsys.kitalpha.ad.viewpoint.predicate", "No contribution found for Predicate ID: " + id);
        throw new CoreException((IStatus)status);
    }

    public Predicate createPredicate(IConfigurationElement predicate) throws CoreException {
        return (Predicate)predicate.createExecutableExtension("class");
    }
}

